/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class StringWriter
extends Writer {
    private StringBuffer buf;

    public StringWriter() {
        this.buf = new StringBuffer();
        this.lock = this.buf;
    }

    public StringWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new StringBuffer(n);
        this.lock = this.buf;
    }

    public void write(int n) {
        this.buf.append((char)n);
    }

    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.buf.append(cArray, n, n2);
    }

    public void write(String string) {
        this.buf.append(string);
    }

    public void write(String string, int n, int n2) {
        this.buf.append(string.substring(n, n + n2));
    }

    public StringWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(((Object)charSequence).toString());
        }
        return this;
    }

    public StringWriter append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        this.write(((Object)charSequence2.subSequence(n, n2)).toString());
        return this;
    }

    public StringWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringBuffer getBuffer() {
        return this.buf;
    }

    public void flush() {
    }

    public void close() throws IOException {
    }
}

