/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.help;

import de.jtem.jrworkspace.plugin.flavor.HelpFlavor;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;

public class HelpBrowser
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JEditorPane editorPane = new JEditorPane();
    private JScrollPane scroller = new JScrollPane(this.editorPane);
    private HTMLEditorKit editorKit = null;
    private HTMLDocument doc = null;
    private HelpFlavor activeHelp = null;
    private LinkedList<Document> history = new LinkedList();

    public HelpBrowser() {
        this.makeLayout();
        this.editorPane.addHyperlinkListener(new JarLinkListener());
        this.editorPane.setEditable(false);
    }

    private void makeLayout() {
        this.setLayout(new GridLayout());
        this.add(this.scroller);
    }

    public void setDocument(HelpFlavor help) {
        if (help.getHelpPath() == null || help.getHelpDocument() == null) {
            return;
        }
        this.activeHelp = help;
        this.editorKit = new HTMLEditorKit();
        this.editorPane.setEditorKit(this.editorKit);
        String pagePath = String.valueOf(help.getHelpPath()) + help.getHelpDocument();
        String cssPath = String.valueOf(help.getHelpPath()) + help.getHelpStyleSheet();
        this.loadCss(cssPath);
        this.loadPage(pagePath, help.getHelpPath());
    }

    private void loadCss(String cssPath) {
        this.editorKit.setStyleSheet(null);
        if (this.activeHelp.getHelpStyleSheet() == null) {
            return;
        }
        try {
            InputStream cssIn = null;
            if (cssPath.startsWith("http://")) {
                URL url = new URL(cssPath);
                cssIn = url.openStream();
            } else {
                cssIn = this.activeHelp.getHelpHandle().getResourceAsStream(cssPath);
            }
            StyleSheet css = new StyleSheet();
            css.loadRules(new InputStreamReader(cssIn), null);
            this.editorKit.setStyleSheet(css);
        }
        catch (Exception e) {
            System.out.println("cannot load style sheet: " + cssPath);
        }
    }

    private void loadPage(String path, String base) {
        try {
            URL baseURL = this.activeHelp.getHelpHandle().getResource(base);
            InputStream in = null;
            if (path.startsWith("http://")) {
                URL url = new URL(path);
                in = url.openStream();
            } else {
                in = this.activeHelp.getHelpHandle().getResourceAsStream(path);
            }
            this.doc = (HTMLDocument)this.editorKit.createDefaultDocument();
            this.doc.setBase(baseURL);
            this.doc.putProperty("IgnoreCharsetDirective", true);
            this.editorKit.read(in, (Document)this.doc, 0);
            this.editorPane.setDocument(this.doc);
        }
        catch (Exception e) {
            System.out.println("cannot load help page: " + path + ": " + e);
        }
        this.history.add(this.doc);
    }

    private class JarLinkListener
    implements HyperlinkListener {
        private JarLinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)HelpBrowser.this.editorPane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else if (e.getURL() != null) {
                    try {
                        HelpBrowser.this.editorKit = new HTMLEditorKit();
                        HelpBrowser.this.editorKit.setStyleSheet(null);
                        HelpBrowser.this.editorPane.setEditorKit(HelpBrowser.this.editorKit);
                        HelpBrowser.this.doc = (HTMLDocument)HelpBrowser.this.editorKit.createDefaultDocument();
                        HelpBrowser.this.editorPane.setDocument(HelpBrowser.this.doc);
                        HelpBrowser.this.editorPane.setPage(e.getURL());
                    }
                    catch (IOException e1) {
                        System.out.println(e1.getLocalizedMessage());
                    }
                } else if (e.getDescription().toLowerCase().endsWith(".html")) {
                    HelpBrowser.this.loadPage(String.valueOf(HelpBrowser.this.activeHelp.getHelpPath()) + e.getDescription(), HelpBrowser.this.activeHelp.getHelpPath());
                } else {
                    HelpBrowser.this.editorPane.scrollToReference(e.getDescription().substring(1));
                }
            }
        }
    }
}

