/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.ruppert;

import de.jtem.numericalMethods.geometry.meshGeneration.ruppert.Delaunay;

public class Ruppert
extends Delaunay {
    private static final long serialVersionUID = 1L;
    double[] cosAngle;
    double[] area;
    double cosLeastAngle;
    double largestArea;
    int maximalNumberOfTriangles;
    int numberOfBadTriangles;
    int maxNob;
    int[] badTriangles;
    int numberOfRejectedBadTriangles;
    int[] rejectedBadTriangles;
    boolean refineFlag;
    double sqrLeastDistance;
    private boolean debug;
    double[] weight;

    public Ruppert(double[][] p) {
        super(p);
        this.cosAngle = new double[3 * this.maximalNumberOfFaces];
        this.area = new double[this.maximalNumberOfFaces];
        this.maximalNumberOfTriangles = 100000;
        this.numberOfBadTriangles = 0;
        this.maxNob = 100000;
        this.badTriangles = new int[this.maxNob];
        this.rejectedBadTriangles = new int[this.maxNob];
        this.refineFlag = false;
        this.sqrLeastDistance = 0.0;
        this.debug = false;
        this.weight = null;
        this.computeAngleAndArea();
        this.refineFlag = true;
        if (this.debug) {
            System.out.println("checking segments");
        }
        this.checkSegments();
        this.cosLeastAngle = this.cosLeastAngle();
        this.largestArea = this.largestArea() * 1.01;
    }

    public void setMaximalNumberOfTriangles(int i) {
        this.maximalNumberOfTriangles = i;
    }

    public int getMaximalNumberOfTriangles() {
        return this.maximalNumberOfTriangles;
    }

    public void setAngleConstraint(double a) {
        this.cosLeastAngle = Math.cos(a * Math.PI / 180.0);
    }

    public double getAngleConstraint() {
        return Math.acos(this.cosLeastAngle) * 180.0 / Math.PI;
    }

    public void setAreaConstraint(double a) {
        this.largestArea = a;
    }

    public double getAreaConstraint() {
        return this.largestArea;
    }

    public void refine(int[] triangleList) {
        int i = 0;
        while (i < triangleList.length) {
            this.refine(triangleList[i]);
            ++i;
        }
    }

    public void refine() {
        this.sqrLeastDistance = 0.25 * Math.min(this.leastEdgeSqr(), this.largestArea);
        this.checkForBadTriangles();
        int oldNob = this.numberOfBadTriangles + 1;
        if (this.debug) {
            System.out.println("start refining");
        }
        while (this.numberOfBadTriangles < oldNob) {
            int j;
            oldNob = this.numberOfBadTriangles;
            int i = 0;
            while (i <= this.numberOfBadTriangles) {
                if (this.numberOfFaces > this.maximalNumberOfTriangles) break;
                j = this.badTriangles[i];
                if (this.bad(j)) {
                    this.refine(j);
                }
                ++i;
            }
            this.numberOfBadTriangles = 0;
            int k = 0;
            while (k < this.numberOfRejectedBadTriangles) {
                j = this.rejectedBadTriangles[k];
                if (this.bad(j)) {
                    this.badTriangles[this.numberOfBadTriangles++] = j;
                }
                ++k;
            }
        }
        if (this.numberOfFaces >= this.maximalNumberOfTriangles && this.debug) {
            System.out.println("reached maximal number of triangles");
        }
        this.result();
    }

    public boolean[] getSegments() {
        boolean[] r = new boolean[3 * this.numberOfFaces];
        System.arraycopy(this.segment, 0, r, 0, 3 * this.numberOfFaces);
        return r;
    }

    public int[] getNeighbors() {
        int[] r = new int[3 * this.numberOfFaces];
        System.arraycopy(this.neighbor, 0, r, 0, 3 * this.numberOfFaces);
        return r;
    }

    @Override
    boolean edgeIllegal(int f, int e) {
        if (this.refineFlag) {
            int fp = 3 * f + e;
            if (this.segment[fp]) {
                return false;
            }
            int n = this.neighbor[fp];
            if (n < 0) {
                return false;
            }
            int np = 2 * this.face[this.getNeighborPtr(n, f)];
            return this.pointInCircle(this.point[np++], this.point[np], f);
        }
        return super.edgeIllegal(f, e);
    }

    void checkSegments() {
        int i = 0;
        while (i < this.numberOfFaces) {
            this.checkSegments(i);
            ++i;
        }
    }

    void checkSegments(int f) {
        int i = 0;
        while (i < 3) {
            this.checkSegment(f, i);
            ++i;
        }
    }

    boolean encroached(int f, int e, double x, double y) {
        int fp = 3 * f;
        int p1 = 2 * this.face[fp + (e + 1) % 3];
        int p2 = 2 * this.face[fp + (e + 2) % 3];
        double x1 = this.point[p1++];
        double y1 = this.point[p1];
        double x2 = this.point[p2++];
        double y2 = this.point[p2];
        this.circleX = (x1 + x2) * 0.5;
        this.circleY = (y1 + y2) * 0.5;
        double xd = x - this.circleX;
        double yd = y - this.circleY;
        double xr = (x2 - x1) * 0.5;
        double yr = (y2 - y1) * 0.5;
        return xd * xd + yd * yd + 1.0E-4 < xr * xr + yr * yr;
    }

    int encroached(int f, double x, double y) {
        int fp = 3 * f;
        int i = 0;
        while (i < 3) {
            if (this.segment[fp] && this.encroached(f, i, x, y)) {
                return i;
            }
            ++i;
            ++fp;
        }
        return -1;
    }

    boolean encroached(int f, int e) {
        int fp = 3 * f + e;
        if (this.segment[fp]) {
            int p0 = 2 * this.face[fp];
            return this.encroached(f, e, this.point[p0++], this.point[p0]);
        }
        return false;
    }

    void checkSegment(int f, int e) {
        if (this.encroached(f, e)) {
            int c = this.numberOfFaces;
            this.addPoint(this.circleX, this.circleY, f, e);
            this.checkSegment(f, e);
            this.checkSegment(c, 0);
        }
    }

    @Override
    void legalizeNewFaces() {
        if (this.refineFlag) {
            int f0 = this.newFace[0];
            int f1 = this.newFace[1];
            int f2 = this.newFace[2];
            int f3 = this.newFace[3];
            super.legalizeNewFaces();
            this.checkSegments(f0);
            this.checkSegments(f1);
            if (f2 >= 0) {
                this.checkSegments(f2);
            }
            if (f3 >= 0) {
                this.checkSegments(f3);
            }
        } else {
            super.legalizeNewFaces();
        }
    }

    @Override
    int flipEdge(int f, int e) {
        if (this.refineFlag) {
            int fp = 3 * f;
            int n = this.neighbor[fp + e];
            int f2 = fp + (e + 2) % 3;
            int np = 3 * n;
            int ne = this.getNeighbor(n, f);
            int n2 = np + (ne + 2) % 3;
            boolean sf = this.segment[f2];
            boolean sn = this.segment[n2];
            int r = super.flipEdge(f, e);
            this.segment[fp + e] = sn;
            this.segment[f2] = false;
            this.segment[np + ne] = sf;
            this.segment[n2] = false;
            this.computeAngleAndArea(f);
            this.computeAngleAndArea(n);
            return r;
        }
        return super.flipEdge(f, e);
    }

    @Override
    void splitTriangle(int f) {
        if (this.refineFlag) {
            int fp = 3 * f;
            int c = this.numberOfFaces;
            int cf = 3 * this.numberOfFaces;
            boolean s0 = this.segment[fp];
            boolean s2 = this.segment[fp + 2];
            super.splitTriangle(f);
            this.segment[fp++] = false;
            this.segment[++fp] = false;
            this.segment[cf++] = false;
            this.segment[cf++] = false;
            this.segment[cf++] = s2;
            this.segment[cf++] = false;
            this.segment[cf++] = false;
            this.segment[cf] = s0;
            this.computeAngleAndArea(f);
            this.computeAngleAndArea(c++);
            this.computeAngleAndArea(c);
        } else {
            super.splitTriangle(f);
        }
    }

    @Override
    void splitEdge(int f, int e) {
        if (this.refineFlag) {
            int fp = 3 * f;
            int f2 = fp + (e + 2) % 3;
            int n = this.neighbor[fp + e];
            int np = 3 * n;
            int c = this.numberOfFaces;
            int cf = 3 * this.numberOfFaces;
            int ne = 0;
            int n1 = 0;
            boolean sf = this.segment[fp + e];
            boolean sf2 = this.segment[f2];
            boolean sn1 = false;
            if (n >= 0) {
                ne = this.getNeighbor(n, f);
                n1 = np + (ne + 1) % 3;
                sn1 = this.segment[n1];
            }
            super.splitEdge(f, e);
            this.segment[f2] = false;
            this.segment[cf++] = sf;
            this.segment[cf++] = false;
            this.segment[cf] = sf2;
            this.computeAngleAndArea(f);
            this.computeAngleAndArea(c);
            if (n >= 0) {
                this.segment[n1] = false;
                this.segment[++cf] = false;
                this.segment[++cf] = sf;
                this.segment[++cf] = sn1;
                this.computeAngleAndArea(n);
                this.computeAngleAndArea(c + 1);
            }
        } else {
            super.splitEdge(f, e);
        }
    }

    void refine(int f) {
        this.computeCircumCircle(f);
        int i = this.findTriangle(this.circleX, this.circleY);
        if (i >= 0) {
            double x = this.circleX;
            double y = this.circleY;
            int j = this.encroached(i, x, y);
            if (j < 0) {
                if (!this.pointIsToClose(x, y, i)) {
                    if (this.pointOnEdge < 0) {
                        this.addPoint(x, y, i);
                    } else {
                        this.checkNeighborForSplit(f, i, x, y);
                    }
                } else {
                    this.rejectBadTriangle(f);
                }
            } else if (!this.pointIsToClose(this.circleX, this.circleY, i)) {
                this.addPoint(this.circleX, this.circleY, i, j);
            } else {
                this.rejectBadTriangle(f);
            }
        } else {
            int e = this.largestEdge(f);
            if (this.segment[3 * f + e]) {
                this.computeMean(f, e);
                if (!this.pointIsToClose(this.circleX, this.circleY, f)) {
                    this.addPoint(this.circleX, this.circleY, f, e);
                } else {
                    this.rejectBadTriangle(f);
                }
            } else {
                this.rejectBadTriangle(f);
            }
        }
    }

    void checkNeighborForSplit(int f, int i, double x, double y) {
        int n = this.neighbor[3 * i + this.pointOnEdge];
        if (n >= 0) {
            if (!this.pointIsTooClose(x, y, n, this.getNeighbor(n, i))) {
                int k = this.encroached(n, x, y);
                if (k < 0) {
                    this.addPoint(x, y, i, this.pointOnEdge);
                } else if (this.pointIsToClose(this.circleX, this.circleY, n)) {
                    this.addPoint(this.circleX, this.circleY, n, k);
                } else {
                    this.rejectBadTriangle(f);
                }
            } else {
                this.rejectBadTriangle(f);
            }
        } else {
            this.addPoint(x, y, i, this.pointOnEdge);
        }
    }

    boolean pointIsToClose(double x, double y, int f) {
        int i = 0;
        while (i < 3) {
            if (this.pointIsTooClose(x, y, f, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean pointIsTooClose(double x, double y, int f, int e) {
        return this.distanceSqr(x, y, f, e) < this.sqrLeastDistance;
    }

    void computeMean(int f, int e) {
        int fp = 3 * f;
        int p1 = 2 * this.face[fp + (e + 1) % 3];
        int p2 = 2 * this.face[fp + (e + 2) % 3];
        this.circleX = 0.5 * (this.point[p1++] + this.point[p2++]);
        this.circleY = 0.5 * (this.point[p1] + this.point[p2]);
    }

    int largestEdge(int f) {
        int fp = 3 * f;
        if (this.cosAngle[fp] < this.cosAngle[fp + 1]) {
            if (this.cosAngle[fp] < this.cosAngle[fp + 2]) {
                return 0;
            }
            return 2;
        }
        if (this.cosAngle[fp + 1] < this.cosAngle[fp + 2]) {
            return 1;
        }
        return 2;
    }

    void computeAngleAndArea(int f) {
        int fp = 3 * f;
        int p0 = 2 * this.face[fp++];
        int p1 = 2 * this.face[fp++];
        int p2 = 2 * this.face[fp];
        double x0 = this.point[p0++];
        double y0 = this.point[p0];
        double x1 = this.point[p1++];
        double y1 = this.point[p1];
        double x2 = this.point[p2++];
        double y2 = this.point[p2];
        double e0x = x1 - x0;
        double e0y = y1 - y0;
        double e1x = x2 - x1;
        double e1y = y2 - y1;
        double e2x = x0 - x2;
        double e2y = y0 - y2;
        double el0 = Math.sqrt(e0x * e0x + e0y * e0y);
        double el1 = Math.sqrt(e1x * e1x + e1y * e1y);
        double el2 = Math.sqrt(e2x * e2x + e2y * e2y);
        fp = 3 * f;
        this.cosAngle[fp++] = -(e0x * e2x + e0y * e2y) / (el0 * el2);
        this.cosAngle[fp++] = -(e0x * e1x + e0y * e1y) / (el0 * el1);
        this.cosAngle[fp] = -(e1x * e2x + e1y * e2y) / (el1 * el2);
        this.area[f] = this.area(f);
        this.checkForBadTriangles(f);
    }

    void computeAngleAndArea() {
        int i = 0;
        while (i < this.numberOfFaces) {
            this.computeAngleAndArea(i);
            ++i;
        }
    }

    public boolean bad(int f) {
        return this.bad(f, this.cosLeastAngle, this.largestArea);
    }

    public boolean bad(int f, double cosLeastAngle, double largestArea) {
        int fp = 3 * f;
        int n = fp++;
        if (this.cosAngle[n] > cosLeastAngle) {
            return true;
        }
        int n2 = fp++;
        if (this.cosAngle[n2] > cosLeastAngle) {
            return true;
        }
        if (this.cosAngle[fp] > cosLeastAngle) {
            return true;
        }
        return this.area[f] > largestArea;
    }

    void checkForBadTriangles() {
        this.numberOfBadTriangles = 0;
        int i = 0;
        while (i < this.numberOfFaces) {
            this.checkForBadTriangles(i);
            ++i;
        }
    }

    void checkForBadTriangles(int f) {
        if (this.bad(f)) {
            this.addToBadTriangles(f);
        }
    }

    void addToBadTriangles(int f) {
        if (this.numberOfBadTriangles == this.maxNob) {
            this.badTriangles = this.doubleSize(this.badTriangles);
            this.rejectedBadTriangles = this.doubleSize(this.rejectedBadTriangles);
            this.maxNob *= 2;
        }
        this.badTriangles[this.numberOfBadTriangles++] = f;
    }

    void rejectBadTriangle(int f) {
        if (this.numberOfRejectedBadTriangles == this.maxNob) {
            this.badTriangles = this.doubleSize(this.badTriangles);
            this.rejectedBadTriangles = this.doubleSize(this.rejectedBadTriangles);
            this.maxNob *= 2;
        }
        this.rejectedBadTriangles[this.numberOfRejectedBadTriangles++] = f;
    }

    @Override
    void checkFaceArray() {
        super.checkFaceArray();
        if (this.area == null) {
            this.area = new double[this.maximalNumberOfFaces];
        }
        if (this.cosAngle == null) {
            this.cosAngle = new double[3 * this.maximalNumberOfFaces];
        }
        if (this.maximalNumberOfFaces > this.area.length) {
            this.area = this.doubleSize(this.area);
            this.cosAngle = this.doubleSize(this.cosAngle);
        }
    }

    double leastEdgeSqr() {
        double r = 4.0 * this.xyBound * this.xyBound;
        int i = 0;
        int c = 0;
        while (i < this.numberOfFaces) {
            int j = 0;
            while (j < 3) {
                int p2;
                int p1;
                double d;
                if (this.neighbor[c + j] < i && r > (d = this.distanceSqr(p1 = this.face[c + (j + 1) % 3], p2 = this.face[c + (j + 2) % 3]))) {
                    r = d;
                }
                ++j;
            }
            ++i;
            c += 3;
        }
        return r;
    }

    double cosLeastAngle() {
        double r = 0.0;
        int imax = 3 * this.numberOfFaces;
        int i = 0;
        while (i < imax) {
            if (this.cosAngle[i] > r) {
                r = this.cosAngle[i];
            }
            ++i;
        }
        return r;
    }

    double largestArea() {
        double r = 0.0;
        int i = 0;
        while (i < this.numberOfFaces) {
            if (this.area[i] > r) {
                r = this.area[i];
            }
            ++i;
        }
        return r;
    }

    void result() {
        if (this.debug) {
            System.out.println("least angle = " + 180.0 * Math.acos(this.cosLeastAngle()) / Math.PI + "  largest area = " + this.largestArea() + "  number of faces = " + this.numberOfFaces);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public double[] getWeight() {
        if (this.weight == null) {
            return null;
        }
        double[] w = new double[this.numberOfPoints];
        System.arraycopy(this.weight, 0, w, 0, this.numberOfPoints);
        return w;
    }

    public void setWeight(double[] w) {
        if (w == null) {
            this.weight = null;
            return;
        }
        if (w.length != this.numberOfPoints) {
            throw new IllegalArgumentException("number of weights != number of points");
        }
        this.weight = new double[this.maximalNumberOfPoints];
        System.arraycopy(w, 0, this.weight, 0, this.numberOfPoints);
    }

    @Override
    void addPoint(double x, double y, int f) {
        if (this.weight != null) {
            this.addWeight(x, y, f, this.numberOfPoints);
        }
        super.addPoint(x, y, f);
    }

    @Override
    void addPoint(double x, double y, int f, int e) {
        if (this.weight != null) {
            this.addWeight(x, y, f, this.numberOfPoints);
        }
        super.addPoint(x, y, f, e);
    }

    @Override
    void checkPointArray() {
        int oldMaxNop = this.maximalNumberOfPoints;
        super.checkPointArray();
        if (this.weight != null && oldMaxNop != this.maximalNumberOfPoints) {
            this.weight = this.doubleSize(this.weight);
        }
    }

    void addWeight(double x, double y, int f, int n) {
        if (this.weight != null) {
            this.weight[n] = this.interpolatedWeight(x, y, f);
        }
    }

    double interpolatedWeight(double x, double y, int f) {
        int p0 = this.face[3 * f];
        int p1 = this.face[3 * f + 1];
        int p2 = this.face[3 * f + 2];
        double x0 = this.point[2 * p0];
        double y0 = this.point[2 * p0 + 1];
        double x1 = this.point[2 * p1];
        double y1 = this.point[2 * p1 + 1];
        double x2 = this.point[2 * p2];
        double y2 = this.point[2 * p2 + 1];
        double d = Ruppert.det(x0, y0, x1, y1, x2, y2);
        return (this.weight[p0] * Ruppert.det(x, y, x1, y1, x2, y2) + this.weight[p1] * Ruppert.det(x0, y0, x, y, x2, y2) + this.weight[p2] * Ruppert.det(x0, y0, x1, y1, x, y)) / d;
    }

    double distanceSqr(int p0, int p1) {
        double x0 = this.point[2 * p0];
        double y0 = this.point[2 * p0 + 1];
        double x1 = this.point[2 * p1];
        double y1 = this.point[2 * p1 + 1];
        double d = (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1);
        if (this.weight != null) {
            d *= 0.5 * (this.weight[p0] + this.weight[p1]);
        }
        return d;
    }

    double distanceSqr(double x, double y, int f, int e) {
        int p = this.face[3 * f + e];
        double x0 = this.point[2 * p];
        double y0 = this.point[2 * p + 1];
        double d = (x0 - x) * (x0 - x) + (y0 - y) * (y0 - y);
        if (this.weight != null) {
            d *= 0.5 * (this.weight[p] + this.interpolatedWeight(x, y, f));
        }
        return d;
    }

    protected double area(int f) {
        int p0 = this.face[3 * f];
        int p1 = this.face[3 * f + 1];
        int p2 = this.face[3 * f + 2];
        double x0 = this.point[2 * p0];
        double y0 = this.point[2 * p0 + 1];
        double x1 = this.point[2 * p1];
        double y1 = this.point[2 * p1 + 1];
        double x2 = this.point[2 * p2];
        double y2 = this.point[2 * p2 + 1];
        double a = Ruppert.det(x0, y0, x1, y1, x2, y2) / 2.0;
        if (this.weight != null) {
            a *= (this.weight[p0] * this.weight[p0] + this.weight[p1] * this.weight[p1] + this.weight[p2] * this.weight[p2]) / 3.0;
        }
        return a;
    }

    static double det(double x0, double y0, double x1, double y1, double x2, double y2) {
        return (y1 - y0) * (x0 - x2) - (x1 - x0) * (y0 - y2);
    }
}

