/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

public final class IntList {
    int[] data;
    int size;

    public IntList(int capacity) {
        this.data = new int[capacity];
        this.size = 0;
    }

    public IntList() {
        this(100);
    }

    public IntList(int[] data) {
        this.data = new int[data.length + (data.length + 10) / 2];
        this.size = data.length;
        System.arraycopy(data, 0, this.data, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.data.length;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.data[index];
    }

    public void set(int index, int value) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.size == index) {
            if (this.size == this.data.length) {
                this.setCapacity(this.data.length + (this.data.length + 10) / 2);
            }
            this.data[this.size++] = value;
        }
        this.data[index] = value;
    }

    public void add(int value) {
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        this.data[this.size++] = value;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
        --this.size;
    }

    public void insert(int index, int value) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = value;
        ++this.size;
    }

    public void setCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException("capacity must exeed size of list");
        }
        int[] newData = new int[capacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }

    public void removeAll() {
        this.size = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("(");
        if (this.size > 0) {
            sb.append(this.data[0]);
            int j = 1;
            while (j < this.size) {
                sb.append(", ");
                sb.append(this.data[j]);
                ++j;
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

