/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.minimizing.Braket;
import de.jtem.numericalMethods.calculus.minimizing.Brent;
import de.jtem.numericalMethods.calculus.minimizing.Line;
import java.io.Serializable;

class RealFunctionOnLine
implements RealFunctionOfOneVariable,
Serializable {
    private static final long serialVersionUID = 1L;
    final RealFunctionOfSeveralVariables f;
    final Line line;

    RealFunctionOnLine(Line line, RealFunctionOfSeveralVariables f) {
        this.line = line;
        this.f = f;
    }

    RealFunctionOnLine(double[] point, double[] direction, RealFunctionOfSeveralVariables f) {
        this(new Line(point, direction), f);
    }

    @Override
    public final double eval(double x) {
        this.line.getPoint(x, this.line.otherPoint);
        return this.f.eval(this.line.otherPoint);
    }

    final double brent(double tol) {
        double[] abc = new double[3];
        double[] valuesAtABC = new double[3];
        double[] result = new double[2];
        abc[0] = -1.0;
        abc[1] = 0.0;
        abc[2] = 1.0;
        Braket.search(abc, valuesAtABC, this);
        Brent.search(abc, result, this, tol);
        double xmin = result[0];
        int j = 0;
        while (j < this.line.n) {
            int n = j;
            int n2 = j++;
            double d = this.line.direction[n2] * xmin;
            this.line.direction[n2] = d;
            this.line.point[n] = this.line.point[n] + d;
        }
        return result[1];
    }
}

