/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class QR {
    public static double decompose(double[][] Q, double[][] R) {
        int n = Q.length;
        double det = 1.0;
        int j = 0;
        while (j < n) {
            int k = 0;
            while (k < j) {
                R[j][k] = 0.0;
                double t = 0.0;
                int i = 0;
                while (i < n) {
                    t += Q[i][k] * Q[i][j];
                    ++i;
                }
                R[k][j] = t;
                i = 0;
                while (i < n) {
                    double[] dArray = Q[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - t * Q[i][k];
                    ++i;
                }
                ++k;
            }
            double t = 0.0;
            int i = 0;
            while (i < n) {
                t += Q[i][j] * Q[i][j];
                ++i;
            }
            t = Math.sqrt(t);
            det *= t;
            R[j][j] = t;
            if (t != 0.0) {
                i = 0;
                while (i < n) {
                    double[] dArray = Q[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] / t;
                    ++i;
                }
            } else {
                i = 0;
                while (i < n) {
                    Q[i][j] = 0.0;
                    ++i;
                }
            }
            ++j;
        }
        return det;
    }

    public static double decompose(double[][] A, double[][] Q, double[][] R) {
        int n = A.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                Q[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        return QR.decompose(Q, R);
    }

    public static double[] decompose(double[][] Q_re, double[][] Q_im, double[][] R_re, double[][] R_im) {
        int n = Q_re.length;
        double det = 1.0;
        int j = 0;
        while (j < n) {
            int i = 0;
            while (i < j) {
                R_re[j][i] = 0.0;
                R_im[j][i] = 0.0;
                double t_re = 0.0;
                double t_im = 0.0;
                int k = 0;
                while (k < n) {
                    double a_re = Q_re[k][i];
                    double a_im = -Q_im[k][i];
                    double b_re = Q_re[k][j];
                    double b_im = Q_im[k][j];
                    t_re += a_re * b_re - a_im * b_im;
                    t_im += a_im * b_re + a_re * b_im;
                    ++k;
                }
                R_re[i][j] = t_re;
                R_im[i][j] = t_im;
                k = 0;
                while (k < n) {
                    double b_re = Q_re[k][i];
                    double b_im = Q_im[k][i];
                    double[] dArray = Q_re[k];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (t_re * b_re - t_im * b_im);
                    double[] dArray2 = Q_im[k];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] - (t_im * b_re + t_re * b_im);
                    ++k;
                }
                ++i;
            }
            double t = 0.0;
            int i2 = 0;
            while (i2 < n) {
                t += Q_re[i2][j] * Q_re[i2][j] + Q_im[i2][j] * Q_im[i2][j];
                ++i2;
            }
            t = Math.sqrt(t);
            det *= t;
            R_re[j][j] = t;
            R_im[j][j] = 0.0;
            if (t != 0.0) {
                i2 = 0;
                while (i2 < n) {
                    double[] dArray = Q_re[i2];
                    int n4 = j;
                    dArray[n4] = dArray[n4] / t;
                    double[] dArray3 = Q_im[i2];
                    int n5 = j;
                    dArray3[n5] = dArray3[n5] / t;
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < n) {
                    Q_re[i2][j] = 0.0;
                    Q_im[i2][j] = 0.0;
                    ++i2;
                }
            }
            ++j;
        }
        return new double[]{det, 0.0};
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[][] Q_re, double[][] Q_im, double[][] R_re, double[][] R_im) {
        int n = A_re.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                Q_re[i][j] = A_re[i][j];
                Q_im[i][j] = A_im[i][j];
                ++j;
            }
            ++i;
        }
        return QR.decompose(Q_re, Q_im, R_re, R_im);
    }
}

