/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.Ringbuffer;
import java.io.PrintStream;
import java.lang.reflect.Array;

public class LFRingbuffer<T>
implements Ringbuffer<T> {
    private final Object syncRead = new Object();
    private final Object syncWrite = new Object();
    private final Object syncGlobal = new Object();
    private volatile T[] array;
    private volatile int capacityPlusOne;
    private volatile int readPos;
    private volatile int writePos;
    private volatile int size;

    @Override
    public final String toString() {
        return "LFRingbuffer<?>[filled " + this.size + " / " + (this.capacityPlusOne - 1) + ", writePos " + this.writePos + ", readPos " + this.readPos + "]";
    }

    @Override
    public final void dump(PrintStream printStream, String string) {
        printStream.println(string + " " + this.toString() + " {");
        for (int i = 0; i < this.capacityPlusOne; ++i) {
            printStream.println("\t[" + i + "]: " + this.array[i]);
        }
        printStream.println("}");
    }

    public LFRingbuffer(T[] TArray) throws IllegalArgumentException {
        this.capacityPlusOne = TArray.length + 1;
        this.array = LFRingbuffer.newArray(TArray.getClass(), this.capacityPlusOne);
        this.resetImpl(true, TArray);
    }

    public LFRingbuffer(Class<? extends T[]> clazz, int n) {
        this.capacityPlusOne = n + 1;
        this.array = LFRingbuffer.newArray(clazz, this.capacityPlusOne);
        this.resetImpl(false, null);
    }

    @Override
    public final T[] getInternalArray() {
        return this.array;
    }

    @Override
    public final int capacity() {
        return this.capacityPlusOne - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this.syncGlobal;
        synchronized (object) {
            this.resetImpl(false, null);
            for (int i = 0; i < this.capacityPlusOne; ++i) {
                this.array[i] = null;
            }
        }
    }

    @Override
    public final void resetFull(T[] TArray) throws IllegalArgumentException {
        this.resetImpl(true, TArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetImpl(boolean bl, T[] TArray) throws IllegalArgumentException {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (null != TArray) {
                if (TArray.length != this.capacityPlusOne - 1) {
                    throw new IllegalArgumentException("copyFrom array length " + TArray.length + " != capacity " + this);
                }
                System.arraycopy(TArray, 0, this.array, 0, TArray.length);
                this.array[this.capacityPlusOne - 1] = null;
            } else if (bl) {
                throw new IllegalArgumentException("copyFrom array is null");
            }
            this.readPos = this.capacityPlusOne - 1;
            if (bl) {
                this.writePos = this.readPos - 1;
                this.size = this.capacityPlusOne - 1;
            } else {
                this.writePos = this.readPos;
                this.size = 0;
            }
        }
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final int getFreeSlots() {
        return this.capacityPlusOne - 1 - this.size;
    }

    @Override
    public final boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public final boolean isFull() {
        return this.capacityPlusOne - 1 == this.size;
    }

    @Override
    public final T get() {
        try {
            return this.getImpl(false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final T getBlocking() throws InterruptedException {
        return this.getImpl(true, false);
    }

    @Override
    public final T peek() {
        try {
            return this.getImpl(false, true);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final T peekBlocking() throws InterruptedException {
        return this.getImpl(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final T getImpl(boolean bl, boolean bl2) throws InterruptedException {
        Object object;
        int n = this.readPos;
        if (n == this.writePos) {
            if (bl) {
                object = this.syncRead;
                synchronized (object) {
                    while (n == this.writePos) {
                        this.syncRead.wait();
                    }
                }
            } else {
                return null;
            }
        }
        n = (n + 1) % this.capacityPlusOne;
        object = this.array[n];
        if (!bl2) {
            this.array[n] = null;
            Object object2 = this.syncWrite;
            synchronized (object2) {
                --this.size;
                this.readPos = n;
                this.syncWrite.notifyAll();
            }
        }
        return (T)object;
    }

    @Override
    public final boolean put(T t) {
        try {
            return this.putImpl(t, false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final void putBlocking(T t) throws InterruptedException {
        if (!this.putImpl(t, false, true)) {
            throw new InternalError("Blocking put failed: " + this);
        }
    }

    @Override
    public final boolean putSame(boolean bl) throws InterruptedException {
        return this.putImpl(null, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean putImpl(T t, boolean bl, boolean bl2) throws InterruptedException {
        Object object;
        int n = this.writePos;
        if ((n = (n + 1) % this.capacityPlusOne) == this.readPos) {
            if (bl2) {
                object = this.syncWrite;
                synchronized (object) {
                    while (n == this.readPos) {
                        this.syncWrite.wait();
                    }
                }
            } else {
                return false;
            }
        }
        if (!bl) {
            this.array[n] = t;
        }
        object = this.syncRead;
        synchronized (object) {
            ++this.size;
            this.writePos = n;
            this.syncRead.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitForFreeSlots(int n) throws InterruptedException {
        Object object = this.syncRead;
        synchronized (object) {
            if (this.capacityPlusOne - 1 - this.size < n) {
                while (this.capacityPlusOne - 1 - this.size < n) {
                    this.syncRead.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void growEmptyBuffer(T[] TArray) throws IllegalStateException, IllegalArgumentException {
        Object object = this.syncGlobal;
        synchronized (object) {
            int n;
            Class<?> clazz;
            if (null == TArray) {
                throw new IllegalArgumentException("newElements is null");
            }
            Class<?> clazz2 = this.array.getClass();
            if (clazz2 != (clazz = TArray.getClass())) {
                throw new IllegalArgumentException("newElements array-type mismatch, internal " + clazz2 + ", newElements " + clazz);
            }
            if (0 != this.size) {
                throw new IllegalStateException("Buffer is not empty: " + this);
            }
            if (this.readPos != this.writePos) {
                throw new InternalError("R/W pos not equal: " + this);
            }
            if (this.readPos != this.writePos) {
                throw new InternalError("R/W pos not equal at empty: " + this);
            }
            int n2 = TArray.length;
            int n3 = this.capacityPlusOne + n2;
            T[] TArray2 = this.array;
            T[] TArray3 = LFRingbuffer.newArray(clazz2, n3);
            this.writePos += n2;
            if (this.readPos >= 0) {
                System.arraycopy(TArray2, 0, TArray3, 0, this.readPos + 1);
            }
            if (n2 > 0) {
                System.arraycopy(TArray, 0, TArray3, this.readPos + 1, n2);
            }
            if ((n = this.capacityPlusOne - 1 - this.readPos) > 0) {
                System.arraycopy(TArray2, this.readPos + 1, TArray3, this.writePos + 1, n);
            }
            this.size = n2;
            this.capacityPlusOne = n3;
            this.array = TArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void growFullBuffer(int n) throws IllegalStateException, IllegalArgumentException {
        Object object = this.syncGlobal;
        synchronized (object) {
            int n2;
            if (0 > n) {
                throw new IllegalArgumentException("amount " + n + " < 0 ");
            }
            if (this.capacityPlusOne - 1 != this.size) {
                throw new IllegalStateException("Buffer is not full: " + this);
            }
            int n3 = (this.writePos + 1) % this.capacityPlusOne;
            if (n3 != this.readPos) {
                throw new InternalError("R != W+1 pos at full: " + this);
            }
            Class<?> clazz = this.array.getClass();
            int n4 = this.capacityPlusOne + n;
            T[] TArray = this.array;
            T[] TArray2 = LFRingbuffer.newArray(clazz, n4);
            this.readPos = (this.writePos + 1 + n) % n4;
            if (this.writePos >= 0) {
                System.arraycopy(TArray, 0, TArray2, 0, this.writePos + 1);
            }
            if ((n2 = this.capacityPlusOne - 1 - this.writePos) > 0) {
                System.arraycopy(TArray, this.writePos + 1, TArray2, this.readPos, n2);
            }
            this.capacityPlusOne = n4;
            this.array = TArray2;
        }
    }

    private static <T> T[] newArray(Class<? extends T[]> clazz, int n) {
        return clazz == Object[].class ? new Object[n] : (Object[])Array.newInstance(clazz.getComponentType(), n);
    }
}

