/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class TrackerRemote
extends VRPNDevice
implements Runnable {
    protected Vector changeListeners = new Vector();
    protected Vector velocityListeners = new Vector();
    protected Vector accelerationListeners = new Vector();
    protected static final Object notifyingChangeListenersLock = new Object();
    protected static final Object notifyingVelocityListenersLock = new Object();
    protected static final Object notifyingAccelerationListenersLock = new Object();

    public TrackerRemote(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        super(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
    }

    public synchronized native int setUpdateRate(double var1);

    public synchronized void addPositionChangeListener(PositionChangeListener listener) {
        this.changeListeners.addElement(listener);
    }

    public synchronized boolean removePositionChangeListener(PositionChangeListener listener) {
        return this.changeListeners.removeElement(listener);
    }

    public synchronized void addVelocityChangeListener(VelocityChangeListener listener) {
        this.velocityListeners.addElement(listener);
    }

    public synchronized boolean removeVelocityChangeListener(VelocityChangeListener listener) {
        return this.velocityListeners.removeElement(listener);
    }

    public synchronized void addAccelerationChangeListener(AccelerationChangeListener listener) {
        this.accelerationListeners.addElement(listener);
    }

    public synchronized boolean removeAccelerationChangeListener(AccelerationChangeListener listener) {
        return this.accelerationListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.changeListeners.removeAllElements();
        this.velocityListeners.removeAllElements();
        this.accelerationListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownTracker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTrackerChange(long tv_sec, long tv_usec, int sensor, double x, double y, double z, double quat0, double quat1, double quat2, double quat3) {
        Object object = notifyingChangeListenersLock;
        synchronized (object) {
            TrackerUpdate t = new TrackerUpdate();
            t.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            t.sensor = sensor;
            t.pos[0] = x;
            t.pos[1] = y;
            t.pos[2] = z;
            t.quat[0] = quat0;
            t.quat[1] = quat1;
            t.quat[2] = quat2;
            t.quat[3] = quat3;
            Enumeration e = this.changeListeners.elements();
            while (e.hasMoreElements()) {
                PositionChangeListener l = (PositionChangeListener)e.nextElement();
                l.trackerPositionUpdate(t, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleVelocityChange(long tv_sec, long tv_usec, int sensor, double x, double y, double z, double quat0, double quat1, double quat2, double quat3, double quat_dt) {
        Object object = notifyingVelocityListenersLock;
        synchronized (object) {
            VelocityUpdate v = new VelocityUpdate();
            v.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            v.sensor = sensor;
            v.vel[0] = x;
            v.vel[1] = y;
            v.vel[2] = z;
            v.vel_quat[0] = quat0;
            v.vel_quat[1] = quat1;
            v.vel_quat[2] = quat2;
            v.vel_quat[3] = quat3;
            v.vel_quat_dt = quat_dt;
            Enumeration e = this.velocityListeners.elements();
            while (e.hasMoreElements()) {
                VelocityChangeListener l = (VelocityChangeListener)e.nextElement();
                l.trackerVelocityUpdate(v, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAccelerationChange(long tv_sec, long tv_usec, int sensor, double x, double y, double z, double quat0, double quat1, double quat2, double quat3, double quat_dt) {
        Object object = notifyingAccelerationListenersLock;
        synchronized (object) {
            AccelerationUpdate a = new AccelerationUpdate();
            a.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            a.sensor = sensor;
            a.acc[0] = x;
            a.acc[1] = y;
            a.acc[2] = z;
            a.acc_quat[0] = quat0;
            a.acc_quat[1] = quat1;
            a.acc_quat[2] = quat2;
            a.acc_quat[3] = quat3;
            a.acc_quat_dt = quat_dt;
            Enumeration e = this.accelerationListeners.elements();
            while (e.hasMoreElements()) {
                AccelerationChangeListener l = (AccelerationChangeListener)e.nextElement();
                l.trackerAccelerationUpdate(a, this);
            }
        }
    }

    protected native void shutdownTracker();

    @Override
    protected native void mainloop();

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    public static interface AccelerationChangeListener {
        public void trackerAccelerationUpdate(AccelerationUpdate var1, TrackerRemote var2);
    }

    public class AccelerationUpdate {
        public Date msg_time = new Date();
        public int sensor = -1;
        public double[] acc = new double[3];
        public double[] acc_quat = new double[4];
        public double acc_quat_dt = 0.0;
    }

    public static interface PositionChangeListener {
        public void trackerPositionUpdate(TrackerUpdate var1, TrackerRemote var2);
    }

    public class TrackerUpdate {
        public Date msg_time = new Date();
        public int sensor = -1;
        public double[] pos = new double[3];
        public double[] quat = new double[4];
    }

    public static interface VelocityChangeListener {
        public void trackerVelocityUpdate(VelocityUpdate var1, TrackerRemote var2);
    }

    public class VelocityUpdate {
        public Date msg_time = new Date();
        public int sensor = -1;
        public double[] vel = new double[3];
        public double[] vel_quat = new double[4];
        public double vel_quat_dt = 0.0;
    }
}

