/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.aggregators;

import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.flavor.ToolBarFlavor;
import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JToolBar;

public abstract class ToolBarAggregator
extends Plugin
implements ToolBarFlavor {
    private HashMap<Class<?>, HashSet<ToolBarItem>> itemMap = new HashMap();
    private JToolBar toolbar = new JToolBar();

    public ToolBarAggregator() {
        this.toolbar.setName(this.getPluginInfo().name);
    }

    private void updateToolBar() {
        LinkedList itemList = new LinkedList();
        for (Set set : this.itemMap.values()) {
            itemList.addAll(set);
        }
        Collections.sort(itemList);
        this.toolbar.removeAll();
        for (ToolBarItem toolBarItem : itemList) {
            if (toolBarItem.item instanceof Action) {
                this.toolbar.add((Action)toolBarItem.item);
                continue;
            }
            if (toolBarItem.item instanceof JToolBar.Separator) {
                this.toolbar.addSeparator();
                continue;
            }
            if (!(toolBarItem.item instanceof Component)) continue;
            this.toolbar.add((Component)toolBarItem.item);
        }
    }

    private void addItem(Class<?> context, ToolBarItem item) {
        if (!this.itemMap.containsKey(context)) {
            this.itemMap.put(context, new HashSet());
        }
        Set set = this.itemMap.get(context);
        set.add(item);
        this.updateToolBar();
    }

    private void removeItem(Class<?> context, Object item) {
        Set set = this.itemMap.get(context);
        if (set == null) {
            return;
        }
        ToolBarItem entry = null;
        for (ToolBarItem i : set) {
            if (i.item != item) continue;
            entry = i;
            break;
        }
        if (entry != null) {
            set.remove(entry);
            this.updateToolBar();
        }
    }

    public void addAction(Class<?> context, double priority, Action a) {
        ToolBarItem item = new ToolBarItem(a, priority);
        this.addItem(context, item);
    }

    public void addTool(Class<?> context, double priority, Component c) {
        ToolBarItem item = new ToolBarItem(c, priority);
        this.addItem(context, item);
    }

    public void addSeparator(Class<?> context, double priority) {
        JToolBar.Separator separator = new JToolBar.Separator();
        ToolBarItem item = new ToolBarItem(separator, priority);
        this.addItem(context, item);
    }

    public void removeAll(Class<?> context) {
        this.itemMap.remove(context);
        this.updateToolBar();
    }

    public void removeAction(Class<?> context, Action a) {
        this.removeItem(context, a);
    }

    public void removeTool(Class<?> context, Component c) {
        this.removeItem(context, c);
    }

    @Override
    public Component getToolBarComponent() {
        return this.toolbar;
    }

    @Override
    public double getToolBarPriority() {
        return 0.0;
    }

    public void setFloatable(boolean fl) {
        this.toolbar.setFloatable(fl);
    }

    private class ToolBarItem
    implements Comparable<ToolBarItem> {
        public Object item = null;
        public double priority = 0.0;

        public ToolBarItem(Object item, double priority) {
            this.item = item;
            this.priority = priority;
        }

        @Override
        public int compareTo(ToolBarItem o) {
            if (this.priority == o.priority) {
                return this.getName().compareTo(o.getName());
            }
            return this.priority < o.priority ? -1 : 1;
        }

        public String getName() {
            if (this.item instanceof Action) {
                Action a = (Action)this.item;
                return (String)a.getValue("Name");
            }
            if (this.item instanceof Component) {
                Component c = (Component)this.item;
                if (c.getName() != null) {
                    return c.getName();
                }
                return "";
            }
            return "";
        }
    }
}

