/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.hyperSurface;

public class MarchingTriangles {
    final int START_CAPACITY = 100;
    double[] point;
    int[] index = new int[200];
    int dimension;
    int numOfPoints = 0;
    int numOfEdges = 0;
    int maxNumOfPoints = 100;
    int maxNumOfEdges = 100;

    public MarchingTriangles(int dimension) {
        this.dimension = dimension;
        this.point = new double[dimension * 100];
    }

    public double[] getPoints() {
        return this.point;
    }

    public int[] getIndices() {
        return this.index;
    }

    public int getNumOfPonits() {
        return this.numOfPoints;
    }

    public int getNumOfPoints() {
        return this.numOfPoints;
    }

    public int getNumOfEdges() {
        return this.numOfEdges;
    }

    public void clear() {
        this.numOfEdges = 0;
        this.numOfPoints = 0;
    }

    void setMaxNumOfPoints(int maxNumOfPoints) {
        if (maxNumOfPoints == this.maxNumOfPoints) {
            return;
        }
        this.maxNumOfPoints = maxNumOfPoints;
        this.numOfPoints = Math.min(this.numOfPoints, maxNumOfPoints);
        double[] newPoint = new double[maxNumOfPoints * this.dimension];
        System.arraycopy(this.point, 0, newPoint, 0, this.numOfPoints * this.dimension);
        this.point = newPoint;
    }

    void setMaxNumOfEdges(int maxNumOfEdges) {
        if (maxNumOfEdges == this.maxNumOfEdges) {
            return;
        }
        this.maxNumOfEdges = maxNumOfEdges;
        this.numOfEdges = Math.min(this.numOfEdges, maxNumOfEdges);
        int[] newIndex = new int[maxNumOfEdges * 2];
        System.arraycopy(this.index, 0, newIndex, 0, this.numOfEdges * 2);
        this.index = newIndex;
    }

    protected void addPointOnEdge(double[] point, int indexP, int indexQ, double tPQ) {
        if (this.numOfPoints >= this.maxNumOfPoints) {
            this.setMaxNumOfPoints(3 * this.maxNumOfPoints / 2 + 1);
        }
        int IP = this.dimension * indexP;
        int IQ = this.dimension * indexQ;
        int k = 0;
        int K = this.numOfPoints * this.dimension;
        while (k < this.dimension) {
            this.point[K] = (1.0 - tPQ) * point[IP] + tPQ * point[IQ];
            ++k;
            ++K;
            ++IP;
            ++IQ;
        }
        ++this.numOfPoints;
    }

    void addEdge(int indexP, int indexQ) {
        if (this.numOfEdges >= this.maxNumOfEdges) {
            this.setMaxNumOfEdges(3 * this.maxNumOfEdges / 2 + 1);
        }
        this.index[2 * this.numOfEdges] = indexP;
        this.index[2 * this.numOfEdges + 1] = indexQ;
        ++this.numOfEdges;
    }

    public static MarchingTriangles compute(double[] point, int dimension, int[] index, int[] neighbour, double[] field, double level) {
        MarchingTriangles il = new MarchingTriangles(dimension);
        il.compute(point, index, neighbour, field, level);
        return il;
    }

    public void compute(double[] point, int[] index, int[] neighbour, double[] field, double level) {
        int noe = index.length / 3;
        int[] intersectionIndex = new int[index.length];
        int i = 0;
        int I = 0;
        int J = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                if (neighbour != null && neighbour[J] != -1 && neighbour[J] < i) {
                    int iN = 3 * neighbour[J];
                    int k = 0;
                    while (k < 3) {
                        if (neighbour[iN + k] == i) {
                            intersectionIndex[J] = intersectionIndex[iN + k];
                            break;
                        }
                        if (k == 2) {
                            throw new RuntimeException("wrong connectivity");
                        }
                        ++k;
                    }
                } else {
                    int indexP = index[I + (j + 1) % 3];
                    double fP = field[indexP] - level;
                    int indexQ = index[I + (j + 2) % 3];
                    double fQ = field[indexQ] - level;
                    if (fP * fQ < 0.0 && fP != fQ) {
                        double tPQ = fP / (fP - fQ);
                        intersectionIndex[J] = this.numOfPoints;
                        this.addPointOnEdge(point, indexP, indexQ, tPQ);
                    } else {
                        intersectionIndex[J] = -1;
                    }
                }
                ++j;
                ++J;
            }
            ++i;
            I += 3;
        }
        this.setMaxNumOfPoints(this.numOfPoints);
        i = 0;
        I = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                int ii = intersectionIndex[I + (j + 1) % 3];
                int jj = intersectionIndex[I + (j + 2) % 3];
                if (ii != -1 && jj != -1) {
                    this.addEdge(ii, jj);
                }
                ++j;
            }
            ++i;
            I += 3;
        }
        this.setMaxNumOfEdges(this.numOfEdges);
    }
}

