/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.polynomial;

import de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial;

public final class ComplexLaurentPolynomial {
    private static final double EPS = 1.0E-14;

    public static void eval(double[] aRe, double[] aIm, int lowerDegOfA, int degOfA, double x, double y, double[] aAtZ) {
        ComplexPolynomial.eval(aRe, aIm, -lowerDegOfA, degOfA, x, y, aAtZ);
        if (lowerDegOfA >= 0) {
            return;
        }
        double xInvOfZ = x / (x * x + y * y);
        double yInvOfZ = -y / (x * x + y * y);
        double resultRe = aRe[0];
        double resultIm = aIm[0];
        int i = lowerDegOfA + 1;
        if (lowerDegOfA < -1) {
            int index = 1;
            while (i < 0 && i <= degOfA) {
                double bRe = resultRe;
                double bIm = resultIm;
                resultRe = bRe * xInvOfZ - bIm * yInvOfZ + aRe[index];
                resultIm = bRe * yInvOfZ + bIm * xInvOfZ + aIm[index];
                ++i;
                ++index;
            }
        }
        while (i <= 0) {
            double bRe = resultRe;
            double bIm = resultIm;
            resultRe = bRe * xInvOfZ - bIm * yInvOfZ;
            resultIm = bRe * yInvOfZ + bIm * xInvOfZ;
            ++i;
        }
        aAtZ[0] = aAtZ[0] + resultRe;
        aAtZ[1] = aAtZ[1] + resultIm;
    }

    public static void evalDerivative(double[] aRe, double[] aIm, int lowerDegOfA, int degOfA, int n, double x, double y, double[] dAAtZ) {
        ComplexPolynomial.evalDerivative(aRe, aIm, -lowerDegOfA, degOfA, n, x, y, dAAtZ);
        if (lowerDegOfA >= 0) {
            return;
        }
        double xInvOfZ = x / (x * x + y * y);
        double yInvOfZ = -y / (x * x + y * y);
        double factor = 1.0;
        int i = 0;
        int j = lowerDegOfA;
        while (i < n) {
            factor *= (double)j;
            ++i;
            --j;
        }
        double resultRe = factor * aRe[0];
        double resultIm = factor * aIm[0];
        int i2 = lowerDegOfA + 1;
        if (lowerDegOfA < -1) {
            int index = 1;
            while (i2 < 0 && i2 <= degOfA) {
                factor /= (double)(i2 - n);
                double bRe = resultRe;
                double bIm = resultIm;
                resultRe = bRe * xInvOfZ - bIm * yInvOfZ + (factor *= (double)i2) * aRe[index];
                resultIm = bRe * yInvOfZ + bIm * xInvOfZ + factor * aIm[index];
                ++i2;
                ++index;
            }
        }
        while (i2 <= n) {
            double bRe = resultRe;
            double bIm = resultIm;
            resultRe = bRe * xInvOfZ - bIm * yInvOfZ;
            resultIm = bRe * yInvOfZ + bIm * xInvOfZ;
            ++i2;
        }
        dAAtZ[0] = dAAtZ[0] + resultRe;
        dAAtZ[1] = dAAtZ[1] + resultIm;
    }

    public static void derivative(double[] aRe, double[] aIm, int lowerDegOfA, int degOfA, int n, double[] bRe, double[] bIm) {
        int i;
        int index;
        int i2;
        double factor;
        if (lowerDegOfA < 0) {
            factor = 1.0;
            i2 = 0;
            int j = lowerDegOfA;
            while (i2 < n) {
                factor *= (double)j;
                ++i2;
                --j;
            }
            bRe[0] = aRe[0] * factor;
            bIm[0] = aIm[0] * factor;
            index = 1;
            i = lowerDegOfA + 1;
            while (i < 0 && i <= degOfA) {
                factor *= (double)i;
                bRe[index] = aRe[index] * (factor /= (double)(i - n));
                bIm[index] = aIm[index] * factor;
                ++i;
                ++index;
            }
            while (index < n - lowerDegOfA && index < degOfA - lowerDegOfA) {
                bRe[index] = 0.0;
                bIm[index] = 0.0;
                ++index;
            }
        }
        if (degOfA >= n) {
            factor = 1.0;
            i2 = degOfA;
            while (i2 > degOfA - n) {
                factor *= (double)i2;
                --i2;
            }
            index = degOfA - lowerDegOfA;
            bRe[index] = aRe[index] * factor;
            bIm[index] = aIm[index] * factor;
            --index;
            i = degOfA - 1;
            while (i >= n && index >= 0) {
                factor *= (double)(i + 1 - n);
                bRe[index] = aRe[index] * (factor /= (double)(i + 1));
                bIm[index] = aIm[index] * factor;
                --i;
                --index;
            }
        }
    }

    public static String toString(double[] re, double[] im, int lowerDegree, int degree) {
        return ComplexLaurentPolynomial.toString(re, im, 0, degree, 1.0E-14);
    }

    public static String toString(double[] re, double[] im, int lowerDegree, int degree, double eps) {
        return ComplexPolynomial.toString(re, im, lowerDegree, degree, eps);
    }
}

