/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp;

import de.smrj.tcp.TCPBroadcaster;
import de.smrj.tcp.util.ByteBufferInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPBroadcasterNIO
extends TCPBroadcaster {
    static final boolean DEBUG = true;
    protected final Set<SelectionKey> clients = new HashSet<SelectionKey>();
    private final Set<SelectionKey> sentClients = new HashSet<SelectionKey>();
    private final Set<SelectionKey> readClients = new HashSet<SelectionKey>();
    private final Map<SelectionKey, ByteBuffer> responseBuffers = new IdentityHashMap<SelectionKey, ByteBuffer>();
    private final Selector writeSel = Selector.open();

    public TCPBroadcasterNIO(int port) throws IOException {
        this(port, 1);
    }

    public TCPBroadcasterNIO(int port, int type) throws IOException {
        super(port, type);
    }

    protected TCPBroadcaster.ClientConnectListener createClientConnectListener() {
        return new ClientConnectListener();
    }

    private boolean checkInLoop() {
        if (this.sentClients.size() != this.clients.size()) {
            return true;
        }
        if (this.getResponseType() == 0) {
            return false;
        }
        return this.readClients.size() != this.clients.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send() throws IOException {
        if (this.getResponseType() != 0) {
            Iterator<ByteBuffer> i = this.responseBuffers.values().iterator();
            while (i.hasNext()) {
                i.next().clear();
            }
        }
        while (this.checkInLoop()) {
            int n = this.writeSel.select();
            Iterator<SelectionKey> it = this.writeSel.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey writeKey = it.next();
                it.remove();
                if (!this.clients.contains(writeKey)) continue;
                try {
                    ByteBuffer bb;
                    if (writeKey.isWritable() && !this.sentClients.contains(writeKey)) {
                        bb = (ByteBuffer)writeKey.attachment();
                        if (bb == null) {
                            bb = this.bosOUT.duplicateBuffer();
                            writeKey.attach(bb);
                        }
                        if (bb.hasRemaining()) {
                            ((SocketChannel)writeKey.channel()).write(bb);
                        } else {
                            writeKey.attach(null);
                            this.sentClients.add(writeKey);
                        }
                    }
                    if (this.getResponseType() == 0 || !writeKey.isReadable() || this.readClients.contains(writeKey)) continue;
                    bb = this.responseBuffers.get(writeKey);
                    if (bb.position() == 0) {
                        bb.limit(1);
                        int read = ((SocketChannel)writeKey.channel()).read(bb);
                        if (bb.position() == 0) continue;
                        byte ret = bb.get(0);
                        if (ret == 0) {
                            this.returnValue = null;
                            this.readClients.add(writeKey);
                            bb.clear();
                            continue;
                        }
                        if (ret != 1) {
                            throw new IllegalStateException("unknown response type");
                        }
                        bb.position(1).limit(5);
                        continue;
                    }
                    if (bb.position() < 5) {
                        ((SocketChannel)writeKey.channel()).read(bb);
                        if (bb.position() < 5) continue;
                        byte[] s = new byte[4];
                        for (int i = 0; i < 4; ++i) {
                            s[i] = bb.get(i + 1);
                        }
                        int size = ByteBuffer.wrap(s).asIntBuffer().get();
                        if (bb.capacity() < size + 5) {
                            ByteBuffer bbNew = ByteBuffer.allocate(size + 5);
                            System.out.println("Increased bb size!");
                            bbNew.position(0).limit(bb.capacity());
                            bb.position(0).limit(5);
                            bbNew.put(bb);
                            this.responseBuffers.put(writeKey, bbNew);
                            bb = bbNew;
                        } else {
                            bb.limit(size + 5);
                        }
                        bb.limit(size + 5);
                        continue;
                    }
                    ((SocketChannel)writeKey.channel()).read(bb);
                    if (bb.hasRemaining()) {
                        System.out.println("reread!");
                    }
                    if (bb.hasRemaining()) continue;
                    try {
                        bb.flip().position(5);
                        this.returnValue = new ObjectInputStream(new ByteBufferInputStream(bb)).readObject();
                    }
                    catch (ClassNotFoundException e) {
                        this.returnValue = e;
                    }
                    finally {
                        this.readClients.add(writeKey);
                    }
                }
                catch (IOException e1) {
                    Logger.getLogger("SMRJ").log(Level.SEVERE, "write error", e1);
                    System.out.println("expecting client disconnect: " + writeKey);
                    this.clients.remove(writeKey);
                    Map<SelectionKey, ByteBuffer> map = this.responseBuffers;
                    synchronized (map) {
                        this.responseBuffers.remove(writeKey);
                    }
                    this.sentClients.remove(writeKey);
                    this.readClients.remove(writeKey);
                }
            }
        }
        this.sentClients.clear();
        this.readClients.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumClients() {
        Map<SelectionKey, ByteBuffer> map = this.responseBuffers;
        synchronized (map) {
            return this.responseBuffers.size();
        }
    }

    public class ClientConnectListener
    extends TCPBroadcaster.ClientConnectListener {
        Selector acceptSel;
        ServerSocketChannel serverSocketChannel;

        public void endAccepting() {
            super.endAccepting();
            try {
                this.serverSocketChannel.socket().close();
                this.serverSocketChannel.close();
                this.acceptSel.wakeup();
                this.acceptSel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        protected void init() throws IOException {
            this.acceptSel = SelectorProvider.provider().openSelector();
            InetSocketAddress is = new InetSocketAddress(System.getProperty("de.smrj.tcp.host", InetAddress.getLocalHost().getHostName()), TCPBroadcasterNIO.this.port);
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.socket().bind(is);
            this.serverSocketChannel.register(this.acceptSel, 16);
            System.out.println("ClientListener.run(): bound to " + is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptClient() throws IOException {
            int n = this.acceptSel.select();
            if (n == 0) {
                if (this.acceptConnections) {
                    throw new IllegalStateException("selector returns 0");
                }
                Logger.getLogger("SMRJ").log(Level.INFO, "TCPBroadcasterNIO: stop accepting clients...");
                return;
            }
            Iterator<SelectionKey> it = this.acceptSel.selectedKeys().iterator();
            if (!this.acceptConnections) {
                return;
            }
            while (it.hasNext()) {
                SelectionKey acceptKey = it.next();
                if (!acceptKey.isAcceptable()) continue;
                ServerSocketChannel server = (ServerSocketChannel)acceptKey.channel();
                SocketChannel channel = server.accept();
                Logger.getLogger("SMRJ").log(Level.INFO, "client connected: " + channel);
                channel.configureBlocking(false);
                while (TCPBroadcasterNIO.this.writeSel == null) {
                    System.out.println("ClientConnectListener.acceptClient() writeSel == null");
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                SelectionKey clientKey = channel.register(TCPBroadcasterNIO.this.writeSel, 5);
                TCPBroadcasterNIO.this.clients.add(clientKey);
                Map map = TCPBroadcasterNIO.this.responseBuffers;
                synchronized (map) {
                    TCPBroadcasterNIO.this.responseBuffers.put(clientKey, ByteBuffer.allocate(0x100000));
                }
                it.remove();
            }
        }
    }
}

