/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.fonts.cmaps.CMapByteCid;
import com.itextpdf.text.pdf.fonts.cmaps.CMapCache;
import com.itextpdf.text.pdf.fonts.cmaps.CMapCidUni;
import com.itextpdf.text.pdf.fonts.cmaps.CMapParserEx;
import com.itextpdf.text.pdf.fonts.cmaps.CMapSequence;
import com.itextpdf.text.pdf.fonts.cmaps.CMapToUnicode;
import com.itextpdf.text.pdf.fonts.cmaps.CidLocationFromByte;
import java.io.IOException;
import java.util.Map;

public class CMapAwareDocumentFont
extends DocumentFont {
    private PdfDictionary fontDic;
    private int spaceWidth;
    private CMapToUnicode toUnicodeCmap;
    private CMapByteCid byteCid;
    private CMapCidUni cidUni;
    private char[] cidbyte2uni;
    private Map<Integer, Integer> uni2cid;

    public CMapAwareDocumentFont(PdfDictionary font) {
        super(font);
        this.fontDic = font;
        this.initFont();
    }

    public CMapAwareDocumentFont(PRIndirectReference refFont) {
        super(refFont);
        this.fontDic = (PdfDictionary)PdfReader.getPdfObjectRelease(refFont);
        this.initFont();
    }

    private void initFont() {
        this.processToUnicode();
        try {
            this.processUni2Byte();
            this.spaceWidth = super.getWidth(32);
            if (this.spaceWidth == 0) {
                this.spaceWidth = this.computeAverageWidth();
            }
            if (this.cjkEncoding != null) {
                this.byteCid = CMapCache.getCachedCMapByteCid(this.cjkEncoding);
                this.cidUni = CMapCache.getCachedCMapCidUni(this.uniMap);
            }
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private void processToUnicode() {
        PdfObject toUni = PdfReader.getPdfObjectRelease(this.fontDic.get(PdfName.TOUNICODE));
        if (toUni instanceof PRStream) {
            try {
                byte[] touni = PdfReader.getStreamBytes((PRStream)toUni);
                CidLocationFromByte lb = new CidLocationFromByte(touni);
                this.toUnicodeCmap = new CMapToUnicode();
                CMapParserEx.parseCid("", this.toUnicodeCmap, lb);
                this.uni2cid = this.toUnicodeCmap.createReverseMapping();
            }
            catch (IOException e) {
                this.toUnicodeCmap = null;
                this.uni2cid = null;
            }
        }
    }

    private void processUni2Byte() throws IOException {
        IntHashtable diffmap;
        IntHashtable uni2byte = this.getUni2Byte();
        int[] e = uni2byte.toOrderedKeys();
        if (e.length == 0) {
            return;
        }
        this.cidbyte2uni = new char[256];
        if (this.toUnicodeCmap == null) {
            for (int k = 0; k < e.length; ++k) {
                int n = uni2byte.get(e[k]);
                if (n >= 256 || this.cidbyte2uni[n] != '\u0000') continue;
                this.cidbyte2uni[n] = (char)e[k];
            }
        } else {
            Map<Integer, Integer> dm = this.toUnicodeCmap.createDirectMapping();
            for (Map.Entry<Integer, Integer> kv : dm.entrySet()) {
                if (kv.getKey() >= 256) continue;
                this.cidbyte2uni[kv.getKey().intValue()] = (char)kv.getValue().intValue();
            }
        }
        if ((diffmap = this.getDiffmap()) != null) {
            e = diffmap.toOrderedKeys();
            for (int k = 0; k < e.length; ++k) {
                int n = diffmap.get(e[k]);
                if (n >= 256) continue;
                this.cidbyte2uni[n] = (char)e[k];
            }
        }
    }

    private int computeAverageWidth() {
        int count = 0;
        int total = 0;
        for (int i = 0; i < this.widths.length; ++i) {
            if (this.widths[i] == 0) continue;
            total += this.widths[i];
            ++count;
        }
        return count != 0 ? total / count : 0;
    }

    public int getWidth(int char1) {
        if (char1 == 32) {
            return this.spaceWidth;
        }
        return super.getWidth(char1);
    }

    private String decodeSingleCID(byte[] bytes, int offset, int len) {
        if (this.toUnicodeCmap != null) {
            if (offset + len > bytes.length) {
                throw new ArrayIndexOutOfBoundsException(MessageLocalization.getComposedMessage("invalid.index.1", offset + len));
            }
            String s = this.toUnicodeCmap.lookup(bytes, offset, len);
            if (s != null) {
                return s;
            }
            if (len != 1 || this.cidbyte2uni == null) {
                return null;
            }
        }
        if (len == 1) {
            if (this.cidbyte2uni == null) {
                return "";
            }
            return new String(this.cidbyte2uni, 0xFF & bytes[offset], 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }

    public String decode(byte[] cidbytes, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        if (this.toUnicodeCmap == null && this.byteCid != null) {
            CMapSequence seq = new CMapSequence(cidbytes, offset, len);
            String cid = this.byteCid.decodeSequence(seq);
            for (int k = 0; k < cid.length(); ++k) {
                int c = this.cidUni.lookup(cid.charAt(k));
                if (c <= 0) continue;
                sb.append(Utilities.convertFromUtf32(c));
            }
        } else {
            for (int i = offset; i < offset + len; ++i) {
                String rslt = this.decodeSingleCID(cidbytes, i, 1);
                if (rslt == null && i < offset + len - 1) {
                    rslt = this.decodeSingleCID(cidbytes, i, 2);
                    ++i;
                }
                if (rslt == null) continue;
                sb.append(rslt);
            }
        }
        return sb.toString();
    }

    public String encode(byte[] bytes, int offset, int len) {
        return this.decode(bytes, offset, len);
    }
}

