/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.sidecontainer;

import de.jtem.jrworkspace.plugin.Controller;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.flavor.PerspectiveFlavor;
import de.jtem.jrworkspace.plugin.sidecontainer.SideContainerLayout;
import de.jtem.jrworkspace.plugin.sidecontainer.image.ImageHook;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkSlot;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkSlotHorizontal;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkSlotVertical;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class SideContainerPerspective
extends Plugin
implements PerspectiveFlavor,
ActionListener {
    private JPanel mainPanel = new JPanel();
    private ShrinkSlotVertical leftSlot = new ShrinkSlotVertical(250);
    private ShrinkSlotVertical rightSlot = new ShrinkSlotVertical(250);
    private ShrinkSlotHorizontal upperSlot = new ShrinkSlotHorizontal();
    private ShrinkSlotHorizontal lowerSlot = new ShrinkSlotHorizontal();
    private JPanel centerPanel = new JPanel();
    private JPanel content = new JPanel();
    private LayoutManager layout = new SideContainerLayout(this.leftSlot, this.rightSlot, this.centerPanel);
    private JMenu panelsMenu = new JMenu("Panels");
    private JMenu containersMenu = new JMenu("Side Panels");
    private JCheckBoxMenuItem hidePanelsItem = new JCheckBoxMenuItem("Hide Alle Panels");
    private JCheckBoxMenuItem showLeftSlotItem = new JCheckBoxMenuItem("Left Slot");
    private JCheckBoxMenuItem showRightSlotItem = new JCheckBoxMenuItem("Right Slot");
    private JCheckBoxMenuItem showTopSlotItem = new JCheckBoxMenuItem("Top Slot");
    private JCheckBoxMenuItem showBottomSlotItem = new JCheckBoxMenuItem("Bottom Slot");
    private boolean hidePanels = false;
    private boolean showLeft = true;
    private boolean showRight = true;
    private boolean showTop = true;
    private boolean showBottom = true;

    public SideContainerPerspective() {
        this(false);
    }

    public SideContainerPerspective(boolean hidePanels) {
        this.hidePanels = hidePanels;
        this.leftSlot.setBorder(BorderFactory.createEtchedBorder());
        this.rightSlot.setBorder(BorderFactory.createEtchedBorder());
        this.upperSlot.setBorder(BorderFactory.createEtchedBorder());
        this.lowerSlot.setBorder(BorderFactory.createEtchedBorder());
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.getContentPanel(), "Center");
        this.mainPanel.setLayout(this.layout);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.panelsMenu.setIcon(ImageHook.getIcon("menu.png"));
        this.containersMenu.add(this.hidePanelsItem);
        this.containersMenu.add(this.showLeftSlotItem);
        this.containersMenu.add(this.showRightSlotItem);
        this.containersMenu.add(this.showTopSlotItem);
        this.containersMenu.add(this.showBottomSlotItem);
        this.hidePanelsItem.setAccelerator(KeyStroke.getKeyStroke(72, 9));
        this.showLeftSlotItem.setAccelerator(KeyStroke.getKeyStroke(37, 9));
        this.showRightSlotItem.setAccelerator(KeyStroke.getKeyStroke(39, 9));
        this.showTopSlotItem.setAccelerator(KeyStroke.getKeyStroke(38, 9));
        this.showBottomSlotItem.setAccelerator(KeyStroke.getKeyStroke(40, 9));
    }

    private void updateStates() {
        if (this.hidePanels) {
            this.centerPanel.remove(this.upperSlot);
            this.centerPanel.remove(this.lowerSlot);
            this.mainPanel.remove(this.rightSlot);
            this.mainPanel.remove(this.leftSlot);
        } else {
            if (this.showTop) {
                if (!SwingUtilities.isDescendingFrom(this.upperSlot, this.centerPanel)) {
                    this.centerPanel.add((Component)this.upperSlot, "North");
                }
            } else {
                this.centerPanel.remove(this.upperSlot);
            }
            if (this.showBottom) {
                if (!SwingUtilities.isDescendingFrom(this.lowerSlot, this.centerPanel)) {
                    this.centerPanel.add((Component)this.lowerSlot, "South");
                }
            } else {
                this.centerPanel.remove(this.lowerSlot);
            }
            if (this.showLeft) {
                if (!SwingUtilities.isDescendingFrom(this.leftSlot, this.mainPanel)) {
                    this.mainPanel.add((Component)this.leftSlot, "West");
                }
            } else {
                this.mainPanel.remove(this.leftSlot);
            }
            if (this.showRight) {
                if (!SwingUtilities.isDescendingFrom(this.rightSlot, this.mainPanel)) {
                    this.mainPanel.add((Component)this.rightSlot, "East");
                }
            } else {
                this.mainPanel.remove(this.rightSlot);
            }
        }
        this.centerPanel.revalidate();
        this.mainPanel.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hidePanels = this.hidePanelsItem.isSelected();
        this.showLeft = this.showLeftSlotItem.isSelected();
        this.showRight = this.showRightSlotItem.isSelected();
        this.showTop = this.showTopSlotItem.isSelected();
        this.showBottom = this.showBottomSlotItem.isSelected();
        this.updateStates();
    }

    @Override
    public void storeStates(Controller c) throws Exception {
        super.storeStates(c);
        c.storeProperty(this.getClass(), "hidePanels", this.hidePanels);
        c.storeProperty(this.getClass(), "showLeft", this.showLeft);
        c.storeProperty(this.getClass(), "showRight", this.showRight);
        c.storeProperty(this.getClass(), "showTop", this.showTop);
        c.storeProperty(this.getClass(), "showBottom", this.showBottom);
    }

    @Override
    public void restoreStates(Controller c) throws Exception {
        super.restoreStates(c);
        this.hidePanels = c.getProperty(this.getClass(), "hidePanels", this.hidePanels);
        this.showLeft = c.getProperty(this.getClass(), "showLeft", this.showLeft);
        this.showRight = c.getProperty(this.getClass(), "showRight", this.showRight);
        this.showTop = c.getProperty(this.getClass(), "showTop", this.showTop);
        this.showBottom = c.getProperty(this.getClass(), "showBottom", this.showBottom);
        this.hidePanelsItem.setSelected(this.hidePanels);
        this.showLeftSlotItem.setSelected(this.showLeft);
        this.showRightSlotItem.setSelected(this.showRight);
        this.showTopSlotItem.setSelected(this.showTop);
        this.showBottomSlotItem.setSelected(this.showBottom);
        this.hidePanelsItem.addActionListener(this);
        this.showLeftSlotItem.addActionListener(this);
        this.showRightSlotItem.addActionListener(this);
        this.showTopSlotItem.addActionListener(this);
        this.showBottomSlotItem.addActionListener(this);
        this.updateStates();
    }

    @Override
    public final Component getCenterComponent() {
        return this.mainPanel;
    }

    public JPanel getContentPanel() {
        return this.content;
    }

    public ShrinkSlot getLeftSlot() {
        return this.leftSlot;
    }

    public ShrinkSlot getRightSlot() {
        return this.rightSlot;
    }

    public ShrinkSlot getUpperSlot() {
        return this.upperSlot;
    }

    public ShrinkSlot getLowerSlot() {
        return this.lowerSlot;
    }

    public JMenu getPanelsMenu() {
        return this.panelsMenu;
    }

    public JMenu getContaintersMenu() {
        return this.containersMenu;
    }

    public void setHidePanels(boolean hidePanels) {
        this.hidePanels = hidePanels;
        this.hidePanelsItem.setSelected(hidePanels);
        this.updateStates();
    }

    public boolean isHidePanels() {
        return this.hidePanels;
    }

    public void setShowLeft(boolean showLeft) {
        this.showLeft = showLeft;
        this.showLeftSlotItem.setSelected(showLeft);
        this.updateStates();
    }

    public boolean isShowLeft() {
        return this.showLeft;
    }

    public void setShowRight(boolean showRight) {
        this.showRight = showRight;
        this.showRightSlotItem.setSelected(showRight);
        this.updateStates();
    }

    public boolean isShowRight() {
        return this.showRight;
    }

    public void setShowTop(boolean showTop) {
        this.showTop = showTop;
        this.showTopSlotItem.setSelected(showTop);
        this.updateStates();
    }

    public boolean isShowTop() {
        return this.showTop;
    }

    public void setShowBottom(boolean showBottom) {
        this.showBottom = showBottom;
        this.showBottomSlotItem.setSelected(showBottom);
        this.updateStates();
    }

    public boolean isShowBottom() {
        return this.showBottom;
    }
}

