/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.executor;

import de.smrj.Broadcaster;
import de.smrj.executor.RemoteCallable;
import de.smrj.executor.RemoteExecutor;
import de.smrj.tcp.TCPBroadcasterNIO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedExecutorService {
    private List<Broadcaster> available = new LinkedList<Broadcaster>();
    private List<Broadcaster> busy = new LinkedList<Broadcaster>();
    private List<Broadcaster> lazy = new LinkedList<Broadcaster>();

    public DistributedExecutorService(String ... hosts) throws IOException {
        int port = 8844;
        int cpPort = 8835;
        LinkedList<TCPBroadcasterNIO> bcs = new LinkedList<TCPBroadcasterNIO>();
        for (String host : hosts) {
            TCPBroadcasterNIO bc = new TCPBroadcasterNIO(port++, 2);
            bcs.add(bc);
        }
        System.out.println("Press Enter when clients have connected...");
        new BufferedReader(new InputStreamReader(System.in)).readLine();
        for (Broadcaster broadcaster : bcs) {
            if (broadcaster.getNumClients() > 0) {
                this.available.add(broadcaster);
                this.lazy.add(broadcaster);
                continue;
            }
            System.out.println("disposing Broadcaster [no connection]: " + broadcaster);
        }
    }

    public <T> Future<T> submit(RemoteCallable<T> task) {
        final Broadcaster bc = this.chooseBroadcaster();
        try {
            final Future f = (Future)bc.getRemoteFactory().createRemoteViaStaticMethod(Future.class, RemoteExecutor.class, "submit", new Class[]{Callable.class}, new Object[]{task});
            return new Future<T>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return f.cancel(mayInterruptIfRunning);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() throws InterruptedException, ExecutionException {
                    Object ret = f.get();
                    DistributedExecutorService distributedExecutorService = DistributedExecutorService.this;
                    synchronized (distributedExecutorService) {
                        DistributedExecutorService.this.busy.remove(bc);
                        DistributedExecutorService.this.lazy.add(bc);
                        DistributedExecutorService.this.notifyAll();
                    }
                    return ret;
                }

                @Override
                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return f.get(timeout, unit);
                }

                @Override
                public boolean isCancelled() {
                    return f.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return f.isDone();
                }
            };
        }
        catch (IOException e) {
            System.out.println("IOE: " + e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Broadcaster chooseBroadcaster() {
        Broadcaster ret = null;
        DistributedExecutorService distributedExecutorService = this;
        synchronized (distributedExecutorService) {
            while (this.lazy.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ret = this.lazy.remove(0);
            this.busy.add(ret);
        }
        return ret;
    }

    public List<Broadcaster> broadcasters() {
        return Collections.unmodifiableList(this.available);
    }

    public void broadcastStaticMethodCall(Class<?> clazz, String methodName, Class<?>[] sig, Object[] params) {
        System.out.println("broadcast call: " + methodName);
        for (Broadcaster bc : this.broadcasters()) {
            System.out.print('.');
            try {
                bc.getRemoteFactory().createRemoteViaStaticMethod(Object.class, clazz, methodName, (Class[])sig, params);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("\ndone.");
    }
}

