/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

import de.jtem.numericalMethods.algebra.linear.decompose.Unmerge;

public class PLR {
    public static double decompose(int[] p, double[][] A) {
        int n = A.length;
        int i = 0;
        while (i < n) {
            p[i] = i;
            ++i;
        }
        double det = 1.0;
        int k = 0;
        while (k < n) {
            double abs = Math.abs(A[k][k]);
            int piv = k;
            int i2 = k + 1;
            while (i2 < n) {
                double t = Math.abs(A[i2][k]);
                if (t > abs) {
                    piv = i2;
                    abs = t;
                }
                ++i2;
            }
            if (k != piv) {
                det *= -1.0;
                int pk = p[k];
                p[k] = p[piv];
                p[piv] = pk;
                double[] Ak = A[k];
                A[k] = A[piv];
                A[piv] = Ak;
            }
            det *= A[k][k];
            i2 = k + 1;
            while (i2 < n) {
                if (abs != 0.0) {
                    double[] dArray = A[i2];
                    int n2 = k;
                    dArray[n2] = dArray[n2] / A[k][k];
                } else {
                    A[i2][k] = 0.0;
                }
                int j = k + 1;
                while (j < n) {
                    double[] dArray = A[i2];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - A[i2][k] * A[k][j];
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        return det;
    }

    public static double decompose(int[][] P, double[][] A, double[][] L, double[][] R) {
        int n = A.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                L[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        int[] p = new int[n];
        double det = PLR.decompose(p, L);
        Unmerge.triangular(L, R);
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < n) {
                P[i2][j] = 0;
                ++j;
            }
            P[i2][p[i2]] = 1;
            ++i2;
        }
        return det;
    }

    public static double[] decompose(int[] p, double[][] A_re, double[][] A_im) {
        int n = A_re.length;
        int i = 0;
        while (i < n) {
            p[i] = i;
            ++i;
        }
        double[] det = new double[]{1.0, 0.0};
        int k = 0;
        while (k < n) {
            int piv = k;
            double x_re = A_re[piv][k];
            double x_im = A_im[piv][k];
            double abs = x_re * x_re + x_im * x_im;
            int i2 = k + 1;
            while (i2 < n) {
                double a_re = A_re[i2][k];
                double a_im = A_im[i2][k];
                double t = a_re * a_re + a_im * a_im;
                if (t > abs) {
                    piv = i2;
                    abs = t;
                }
                ++i2;
            }
            if (k != piv) {
                det[0] = det[0] * -1.0;
                det[1] = det[1] * -1.0;
                int pk = p[k];
                p[k] = p[piv];
                p[piv] = pk;
                double[] Ak = A_re[k];
                A_re[k] = A_re[piv];
                A_re[piv] = Ak;
                Ak = A_im[k];
                A_im[k] = A_im[piv];
                A_im[piv] = Ak;
            }
            double d0 = det[0] * A_re[k][k] - det[1] * A_im[k][k];
            det[1] = det[0] * A_im[k][k] + det[1] * A_re[k][k];
            det[0] = d0;
            int i3 = k + 1;
            while (i3 < n) {
                if (abs != 0.0) {
                    double a_re = A_re[i3][k];
                    double a_im = A_im[i3][k];
                    double b_re = A_re[k][k];
                    double b_im = -A_im[k][k];
                    double t = b_re * b_re + b_im * b_im;
                    A_re[i3][k] = (a_re * b_re - a_im * b_im) / t;
                    A_im[i3][k] = (a_im * b_re + a_re * b_im) / t;
                } else {
                    A_re[i3][k] = 0.0;
                    A_im[i3][k] = 0.0;
                }
                int j = k + 1;
                while (j < n) {
                    double a_re = A_re[i3][k];
                    double a_im = A_im[i3][k];
                    double b_re = A_re[k][j];
                    double b_im = A_im[k][j];
                    double[] dArray = A_re[i3];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (a_re * b_re - a_im * b_im);
                    double[] dArray2 = A_im[i3];
                    int n3 = j++;
                    dArray2[n3] = dArray2[n3] - (a_im * b_re + a_re * b_im);
                }
                ++i3;
            }
            ++k;
        }
        return det;
    }

    public static double[] decompose(int[][] P, double[][] A_re, double[][] A_im, double[][] L_re, double[][] L_im, double[][] R_re, double[][] R_im) {
        int n = A_re.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                L_re[i][j] = A_re[i][j];
                L_im[i][j] = A_im[i][j];
                ++j;
            }
            ++i;
        }
        int[] p = new int[n];
        double[] det = PLR.decompose(p, L_re, L_im);
        Unmerge.triangular(L_re, L_im, R_re, R_im);
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < n) {
                P[i2][j] = 0;
                ++j;
            }
            P[i2][p[i2]] = 1;
            ++i2;
        }
        return det;
    }
}

