/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.util.StringUtil;

public class CSVRenderer
extends AbstractRenderer {
    public void render(Writer writer, Report report) throws IOException {
        StringBuffer buf = new StringBuffer(300);
        this.quoteAndCommify(buf, "Problem");
        this.quoteAndCommify(buf, "Package");
        this.quoteAndCommify(buf, "File");
        this.quoteAndCommify(buf, "Priority");
        this.quoteAndCommify(buf, "Line");
        this.quoteAndCommify(buf, "Description");
        this.quoteAndCommify(buf, "Rule set");
        this.quote(buf, "Rule");
        buf.append(PMD.EOL);
        writer.write(buf.toString());
        this.addViolations(writer, report, buf);
    }

    private void addViolations(Writer writer, Report report, StringBuffer buf) throws IOException {
        int violationCount = 1;
        Iterator i = report.iterator();
        while (i.hasNext()) {
            buf.setLength(0);
            IRuleViolation rv = (IRuleViolation)i.next();
            this.quoteAndCommify(buf, Integer.toString(violationCount));
            this.quoteAndCommify(buf, rv.getPackageName());
            this.quoteAndCommify(buf, rv.getFilename());
            this.quoteAndCommify(buf, Integer.toString(rv.getRule().getPriority()));
            this.quoteAndCommify(buf, Integer.toString(rv.getBeginLine()));
            this.quoteAndCommify(buf, StringUtil.replaceString(rv.getDescription(), '\"', "'"));
            this.quoteAndCommify(buf, rv.getRule().getRuleSetName());
            this.quote(buf, rv.getRule().getName());
            buf.append(PMD.EOL);
            writer.write(buf.toString());
            ++violationCount;
        }
    }

    private void quote(StringBuffer sb, String d) {
        sb.append('\"').append(d).append('\"');
    }

    private void quoteAndCommify(StringBuffer sb, String d) {
        this.quote(sb, d);
        sb.append(',');
    }
}

