/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.internal.DocumentSorter;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonExprVisitor;
import net.sourceforge.pmd.lang.rule.xpath.internal.SplitUnions;

public class RuleChainAnalyzer
extends SaxonExprVisitor {
    private final Configuration configuration;
    private String rootElement;
    private boolean rootElementReplaced;
    private boolean insideLazyExpression;
    private boolean foundPathInsideLazy;
    private boolean foundCombinedNodeTest;

    public RuleChainAnalyzer(Configuration currentConfiguration) {
        this.configuration = currentConfiguration;
    }

    public String getRootElement() {
        if (!this.foundPathInsideLazy && this.rootElementReplaced) {
            return this.rootElement;
        }
        return null;
    }

    @Override
    public Expression visit(net.sf.saxon.sort.DocumentSorter e) {
        net.sf.saxon.sort.DocumentSorter result = (net.sf.saxon.sort.DocumentSorter)super.visit(e);
        return result.getBaseExpression();
    }

    @Override
    public Expression visit(PathExpression e) {
        if (!this.insideLazyExpression && this.rootElement == null) {
            Expression result = super.visit(e);
            if (this.rootElement != null && !this.rootElementReplaced) {
                if (result instanceof PathExpression) {
                    PathExpression newPath = (PathExpression)result;
                    Expression step = newPath.getStepExpression();
                    if (step instanceof FilterExpression) {
                        FilterExpression filterExpression = (FilterExpression)newPath.getStepExpression();
                        ArrayDeque<Expression> filters = new ArrayDeque<Expression>();
                        FilterExpression walker = filterExpression;
                        while (walker instanceof FilterExpression) {
                            filters.push(walker.getFilter());
                            walker = walker.getBaseExpression();
                        }
                        result = new FilterExpression((Expression)new AxisExpression(12, null), (Expression)filters.pop());
                        while (!filters.isEmpty()) {
                            result = new FilterExpression(result, (Expression)filters.pop());
                        }
                        this.rootElementReplaced = true;
                    } else if (step instanceof AxisExpression && newPath.getStartExpression() instanceof RootExpression) {
                        result = new AxisExpression(12, null);
                        this.rootElementReplaced = true;
                    }
                } else {
                    result = new AxisExpression(5, null);
                    this.rootElementReplaced = true;
                }
            }
            return result;
        }
        if (this.insideLazyExpression) {
            this.foundPathInsideLazy = true;
        }
        return super.visit(e);
    }

    @Override
    public Expression visit(AxisExpression e) {
        if (this.rootElement == null && e.getNodeTest() instanceof NameTest && !this.foundCombinedNodeTest) {
            NameTest test = (NameTest)e.getNodeTest();
            if (test.getPrimitiveType() == 1 && e.getAxis() == 4) {
                this.rootElement = this.configuration.getNamePool().getClarkName(test.getFingerprint());
            } else if (test.getPrimitiveType() == 1 && e.getAxis() == 3) {
                this.rootElement = this.configuration.getNamePool().getClarkName(test.getFingerprint());
            }
        } else if (e.getNodeTest() instanceof CombinedNodeTest) {
            this.foundCombinedNodeTest = true;
        }
        return super.visit(e);
    }

    @Override
    public Expression visit(LazyExpression e) {
        boolean prevCtx = this.insideLazyExpression;
        this.insideLazyExpression = true;
        Expression result = super.visit(e);
        this.insideLazyExpression = prevCtx;
        return result;
    }

    public static Comparator<Node> documentOrderComparator() {
        return DocumentSorter.INSTANCE;
    }

    public static Iterable<Expression> splitUnions(Expression expr) {
        SplitUnions unions = new SplitUnions();
        unions.visit(expr);
        if (unions.getExpressions().isEmpty()) {
            return Collections.singletonList(expr);
        }
        return unions.getExpressions();
    }
}

