/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import java.util.ArrayDeque;
import java.util.Deque;

public class StackScope<T>
extends Scope {
    private final Deque<T> stack = new ArrayDeque<T>();

    public static <T> T evaluate(AstNode node, AstVisitor<StackScope<T>> visitor) {
        StackScope<T> scope = new StackScope<T>();
        node.traverse(visitor, scope);
        assert (scope.stack.size() == 1) : "we over pushed the stack: " + scope.stack;
        return scope.pop();
    }

    public Deque<T> get() {
        return this.stack;
    }

    public T pop() {
        return this.stack.pop();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void push(T value) {
        this.stack.push(value);
    }

    public String toString() {
        return String.valueOf(this.stack);
    }
}

