/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DatabaseEmitMethods;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class DmlUndeleteStatement
extends Statement {
    private static final DmlOperation OP = DmlOperation.UNDELETE;
    private final Location loc;
    private final Expression expression;

    public DmlUndeleteStatement(AstNode definingNode, Stmnt.DmlUndeleteStmnt x) {
        super(definingNode);
        this.loc = x.loc;
        this.expression = AstNodes.get().create((AstNode)this, x.expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo typeToCheck = TypeInfoUtil.peelType(this.expression.getType());
        if (typeToCheck.getBasicType() != BasicType.SOBJECT) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.dml.type", this.expression.getType()));
            return;
        }
        if (!SObjectTypeInfoUtil.isDmlOperationAllowedStatically(this.getDefiningType(), DmlOperation.DELETE, typeToCheck)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("dml.operation.not.allowed", DmlOperation.UNDELETE.getApexName(), this.expression.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.loc, true, false);
        this.expression.emit(emitter);
        ProfilingType.DML.emit(emitter, this.loc, OP.getName(this.expression.getType()));
        emitter.emit(this.loc, CollectionTypeInfoUtil.isList(this.expression.getType()) ? (CollectionTypeInfoUtil.getElementType(this.expression.getType()).getBasicType() == BasicType.ID ? DatabaseEmitMethods.DML_UNDELETE_ID : DatabaseEmitMethods.dmlList(OP)) : DatabaseEmitMethods.dml(OP));
        emitter.emit(this.loc, 87);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

