/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.compilation.UserExceptionMethods;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.ExpressionStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.EmitScope;
import apex.jorje.semantic.ast.visitor.InitializeUseBeforeDefinedVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.ConstructorCall;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.List;

public class ConstructorPreambleStatement
extends Statement {
    private static final Signature EMPTY_CONSTRUCTOR = SignatureFactory.create("<init>", TypeInfos.VOID);
    private static final Emit FINALLY_EMIT = emitter -> emitter.emit(Locations.NONE, SystemEmitMethods.POP_TRANSPARENT_FRAME);
    private static final AstVisitor<ValueScope<ConstructorCall>> GET_CONSTRUCTOR_CALL = new AstVisitor<ValueScope<ConstructorCall>>(){

        @Override
        public void visitEnd(BlockStatement node, ValueScope<ConstructorCall> scope) {
            MoreIterables.getFirst(node.getStatements(), Statement.NOOP).traverse(this, scope);
        }

        @Override
        public void visitEnd(SuperMethodCallExpression node, ValueScope<ConstructorCall> scope) {
            scope.setValue(ConstructorCall.SUPER);
        }

        @Override
        public void visitEnd(ThisMethodCallExpression node, ValueScope<ConstructorCall> scope) {
            scope.setValue(ConstructorCall.THIS);
        }

        @Override
        public boolean visit(ExpressionStatement node, ValueScope<ConstructorCall> scope) {
            return true;
        }
    };
    private final Statement root;
    private final Location loc;
    private List<Statement> classStatements;
    private ConstructorCall call;

    public ConstructorPreambleStatement(AstNode definingNode, Location loc, Statement root) {
        super(definingNode);
        this.loc = loc;
        this.root = root;
        this.setReturnable();
    }

    private static Emit createInitPreamble(List<Statement> classStatements) {
        return emitter -> {
            TypeStack.TypeContext context = emitter.getTypeStack().peek();
            boolean pushTransparentFrame = context.getCodeUnitDetails().getVersion().isLessThan(Version.V178);
            if (pushTransparentFrame) {
                emitter.emit(Locations.NONE, SystemEmitMethods.PUSH_TRANSPARENT_FRAME);
                emitter.getTryCatchFinallyStack().push(FINALLY_EMIT);
                emitter.getTryCatchFinallyStack().startTryBlock();
            }
            if (Version.V174.isGreaterThanOrEqual(context.getCodeUnitDetails().getVersion())) {
                EmitScope emitContext = new EmitScope(emitter);
                for (Statement statement : classStatements) {
                    statement.traverse(InitializeUseBeforeDefinedVisitor.get(), emitContext);
                }
            }
            for (Statement statement : classStatements) {
                statement.emit(emitter);
            }
            if (classStatements.isEmpty()) {
                emitter.emit(Locations.NONE, 0);
            }
            if (pushTransparentFrame) {
                emitter.getTryCatchFinallyStack().endBlock();
                emitter.getTryCatchFinallyStack().pop(Emit.NOOP);
            }
        };
    }

    private static ConstructorCall getConstructorCall(Statement statement) {
        return ValueScope.evaluate(statement, GET_CONSTRUCTOR_CALL, ConstructorCall.NONE);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        TypeInfo superType;
        this.classStatements = scope.getClassStatements();
        Errors errors = scope.getErrors();
        if (errors.isInvalid(this.classStatements)) {
            errors.markInvalid(this);
        }
        this.call = ConstructorPreambleStatement.getConstructorCall(this.root);
        TypeInfo definingType = this.getDefiningType();
        if (this.call == ConstructorCall.NONE && (superType = definingType.parents().superType()) != null) {
            MethodInfo defaultConstructor = superType.methods().get(EMPTY_CONSTRUCTOR);
            if (defaultConstructor == null) {
                if (!TypeInfoEquivalence.isEquivalent(definingType, InternalTypeInfos.APEX_EXCEPTION)) {
                    errors.markInvalid((AstNode)this, this.loc, I18nSupport.getLabel("invalid.default.constructor", superType));
                }
            } else if (!Visibility.isMethodVisible(symbols.getAccessEvaluator(), definingType, defaultConstructor, Visibility.ReferencedFromTestMethod.NO)) {
                errors.markInvalid((AstNode)this, this.loc, I18nSupport.getLabel("method.not.visible", defaultConstructor));
            }
        }
    }

    @Override
    public void emit(final Emitter emitter) {
        TypeStack.TypeContext context = emitter.getTypeStack().peek();
        if (this.call != ConstructorCall.THIS) {
            emitter.emitStatementExecuted(context.getLoc(), false, false);
            SystemModeEmit.emitter().withType(context.getType()).withBody(ConstructorPreambleStatement.createInitPreamble(this.classStatements)).emit(emitter);
        }
        if (this.root == Statement.NOOP) {
            return;
        }
        Location loc = emitter.getMethodStack().peek().getMethodInfo().getLoc();
        TypeInfo parentType = context.getType().parents().superType();
        if (this.call == ConstructorCall.NONE) {
            if (ExceptionTypeInfoUtil.isException(emitter) && !emitter.getType().getCodeUnitDetails().isFileBased() && TypeInfoEquivalence.isEquivalent(parentType, InternalTypeInfos.APEX_EXCEPTION)) {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.push(Locations.NONE, "Script-thrown exception");
                emitter.emit(Locations.NONE, ObjectEmitMethods.constructor(TypeInfos.EXCEPTION, TypeInfos.STRING));
                UserExceptionMethods.PUT_DEFAULT_MESSAGE.emit(emitter);
            } else if (!TypeInfoEquivalence.isEquivalent(InternalTypeInfos.APEX_OBJECT, parentType)) {
                emitter.emitVar(loc, 25, 0);
                emitter.emit(loc, ObjectEmitMethods.constructor(parentType));
            } else {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emit(Locations.NONE, ObjectEmitMethods.constructor(InternalTypeInfos.APEX_OBJECT));
            }
        } else {
            this.root.traverse(new AstVisitor<Scope>(){

                @Override
                public void visitEnd(BlockStatement node, Scope scope) {
                    node.emitFirstStatement(emitter);
                }
            }, NoopScope.get());
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }
}

