/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRules;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreSets;
import java.util.Set;
import java.util.function.Function;

public class AnnotationRuleGroup {
    public static final AnnotationRuleGroup EMPTY = AnnotationRuleGroup.builder().build();
    private final ModifierOrAnnotationTypeInfo modifier;
    private final Set<AnnotationRule> softRules;
    private final Set<AnnotationRule> hardRules;
    private final AnnotationContextRule contextRule;

    private AnnotationRuleGroup(Builder builder) {
        this.modifier = builder.modifier;
        this.softRules = builder.softRules;
        this.hardRules = builder.hardRules;
        this.contextRule = builder.contextRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(AnnotationContext context) {
        if (context.getModifiers().getDuplicates().contains(this.modifier)) {
            context.addError(I18nSupport.getLabel("duplicate.modifier", this.modifier));
        }
        for (AnnotationRule rule : this.hardRules) {
            rule.validate(context, context.getModifiers(), this.modifier.toString());
            if (!context.getErrors().isInvalid(context.getNode())) continue;
            return;
        }
        for (AnnotationRule rule : this.softRules) {
            rule.validate(context, context.getModifiers(), this.modifier.toString());
        }
        if (this.contextRule != null) {
            context.accept(this.contextRule);
        }
    }

    public static class Builder {
        private static final Function<ModifierOrAnnotationTypeInfo, Boolean> HAS_ALLOWED_ELEMENTS = modifier -> modifier == ModifierTypeInfos.PUBLIC || modifier == ModifierTypeInfos.PRIVATE;
        private Set<AnnotationRule> softRules = ImmutableSet.of();
        private Set<AnnotationRule> hardRules = ImmutableSet.of();
        private AnnotationContextRule contextRule;
        private ModifierOrAnnotationTypeInfo modifier;

        private Builder() {
        }

        public AnnotationRuleGroup build() {
            assert (this.modifier == null || HAS_ALLOWED_ELEMENTS.apply(this.modifier).booleanValue() || MoreIterables.ensureAny(this.hardRules, input -> input instanceof AnnotationRules.AllowedElementsRule)) : "illegal modifier/annotation without element specific rule";
            return new AnnotationRuleGroup(this);
        }

        public Builder setContextRule(AnnotationContextRule contextRule) {
            this.contextRule = contextRule;
            return this;
        }

        public Builder addSoftRules(AnnotationRule ... softRules) {
            assert (softRules.length > 0) : "no soft rules included";
            this.softRules = ImmutableSet.copyOf(MoreSets.newLinkedHashSet(softRules));
            return this;
        }

        public Builder addHardRules(AnnotationRule ... rules) {
            assert (rules.length > 0) : "no hard rules included";
            this.hardRules = ImmutableSet.copyOf(MoreSets.newLinkedHashSet(rules));
            return this;
        }

        public Builder setModifier(ModifierOrAnnotationTypeInfo modifier) {
            this.modifier = modifier;
            return this;
        }
    }
}

