/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

final class Modifiers {
    private static final Factory FACTORY = NoLocFactory.get();

    private Modifiers() {
    }

    static Factory get() {
        return FACTORY;
    }

    @VisibleForTesting
    static class WithLocFactory
    implements Factory {
        private static final Factory INSTANCE = new WithLocFactory();

        private WithLocFactory() {
        }

        public static Factory get() {
            return INSTANCE;
        }

        @Override
        public Modifier createModifier(Location loc, ModifierTypeInfo type) {
            return new Modifier(loc, type);
        }
    }

    @VisibleForTesting
    static class NoLocFactory
    implements Factory {
        private static final Factory INSTANCE = new NoLocFactory();
        private static final Map<ModifierTypeInfo, Modifier> TYPE_TO_MODIFIER = ImmutableMap.builder().put(ModifierTypeInfos.TEST_METHOD, new Modifier(Locations.NONE, ModifierTypeInfos.TEST_METHOD)).put(ModifierTypeInfos.PUBLIC, new Modifier(Locations.NONE, ModifierTypeInfos.PUBLIC)).put(ModifierTypeInfos.PROTECTED, new Modifier(Locations.NONE, ModifierTypeInfos.PROTECTED)).put(ModifierTypeInfos.PRIVATE, new Modifier(Locations.NONE, ModifierTypeInfos.PRIVATE)).put(ModifierTypeInfos.GLOBAL, new Modifier(Locations.NONE, ModifierTypeInfos.GLOBAL)).put(ModifierTypeInfos.WEB_SERVICE, new Modifier(Locations.NONE, ModifierTypeInfos.WEB_SERVICE)).put(ModifierTypeInfos.WITH_SHARING, new Modifier(Locations.NONE, ModifierTypeInfos.WITH_SHARING)).put(ModifierTypeInfos.INHERITED_SHARING, new Modifier(Locations.NONE, ModifierTypeInfos.INHERITED_SHARING)).put(ModifierTypeInfos.WITHOUT_SHARING, new Modifier(Locations.NONE, ModifierTypeInfos.WITHOUT_SHARING)).put(ModifierTypeInfos.STATIC, new Modifier(Locations.NONE, ModifierTypeInfos.STATIC)).put(ModifierTypeInfos.TRANSIENT, new Modifier(Locations.NONE, ModifierTypeInfos.TRANSIENT)).put(ModifierTypeInfos.ABSTRACT, new Modifier(Locations.NONE, ModifierTypeInfos.ABSTRACT)).put(ModifierTypeInfos.FINAL, new Modifier(Locations.NONE, ModifierTypeInfos.FINAL)).put(ModifierTypeInfos.OVERRIDE, new Modifier(Locations.NONE, ModifierTypeInfos.OVERRIDE)).put(ModifierTypeInfos.VIRTUAL, new Modifier(Locations.NONE, ModifierTypeInfos.VIRTUAL)).put(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, new Modifier(Locations.NONE, ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED)).put(ModifierTypeInfos.LEGACY_DEFAULT_GETTER, new Modifier(Locations.NONE, ModifierTypeInfos.LEGACY_DEFAULT_GETTER)).put(ModifierTypeInfos.LEGACY_DEFAULT_SETTER, new Modifier(Locations.NONE, ModifierTypeInfos.LEGACY_DEFAULT_SETTER)).put(ModifierTypeInfos.ACC_INTERFACE, new Modifier(Locations.NONE, ModifierTypeInfos.ACC_INTERFACE)).put(ModifierTypeInfos.HIDDEN, new Modifier(Locations.NONE, ModifierTypeInfos.HIDDEN)).put(ModifierTypeInfos.BRIDGE, new Modifier(Locations.NONE, ModifierTypeInfos.BRIDGE)).build();

        private NoLocFactory() {
        }

        public static Factory get() {
            return INSTANCE;
        }

        @Override
        public Modifier createModifier(Location loc, ModifierTypeInfo type) {
            Modifier modifier = TYPE_TO_MODIFIER.get(type);
            if (modifier == null) {
                throw new UnexpectedCodePathException("Unknown modifier type: " + type.toString());
            }
            return modifier;
        }
    }

    static interface Factory {
        public Modifier createModifier(Location var1, ModifierTypeInfo var2);
    }
}

