/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.condition;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.condition.Condition;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import org.objectweb.asm.Label;

public class StandardCondition
implements Condition {
    private final TypeInfo definingType;
    private final Expression condition;
    private Label falseLabel;

    public StandardCondition(AstNode definingNode, Expr expr) {
        this.definingType = definingNode.getDefiningType();
        this.condition = AstNodes.get().create((AstNode)this, expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.condition.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.condition)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!this.condition.getType().equals(TypeInfos.BOOLEAN)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.condition.type", this.condition.getType()));
        }
    }

    @Override
    public void emit(final Emitter emitter) {
        this.condition.traverse(new AstVisitor<NoopScope>(){

            @Override
            protected boolean defaultVisit() {
                StandardCondition.this.falseLabel = new Label();
                StandardCondition.this.condition.emit(emitter);
                emitter.unbox(StandardCondition.this.condition.getType());
                emitter.emitJump(StandardCondition.this.condition.getLoc(), 153, StandardCondition.this.falseLabel);
                return false;
            }

            @Override
            public boolean visit(BooleanExpression node, NoopScope scope) {
                if (node.getOp().isComparison()) {
                    node.emitComparison(emitter);
                    StandardCondition.this.falseLabel = node.getFalseLabel();
                    node.resetLabels();
                } else {
                    StandardCondition.this.condition.emit(emitter);
                    StandardCondition.this.falseLabel = node.getFalseLabel();
                    node.resetLabels();
                    emitter.unbox(StandardCondition.this.condition.getType());
                    emitter.emitJump(StandardCondition.this.condition.getLoc(), 153, StandardCondition.this.falseLabel);
                }
                return false;
            }
        }, NoopScope.get());
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Location getLoc() {
        return this.condition.getLoc();
    }

    @Override
    public Label getFalseLabel(Emitter emitter) {
        this.emit(emitter);
        return this.falseLabel;
    }
}

