/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.typeinference;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.typeresolution.MethodTypeResolution;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinition;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Bound;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.BoundOrConstraint;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Constraint;

@Deprecated
@InternalApi
public enum InferenceRuleType {
    EQUALITY{

        @Override
        public List<BoundOrConstraint> reduce(BoundOrConstraint val) {
            if (val.isLeftType() && val.isRightType()) {
                ArrayList<BoundOrConstraint> newConstraints = new ArrayList<BoundOrConstraint>();
                if (val.isLeftProper() && val.isRightProper()) {
                    if (val.leftProper().equals(val.rightProper())) {
                        return newConstraints;
                    }
                    return null;
                }
                if (val.isLeftNull() || val.isRightNull()) {
                    return null;
                }
                if (val.isLeftVariable() && !val.isRightPrimitive()) {
                    newConstraints.add(InferenceRuleType.copyBound(val, 1.EQUALITY));
                    return newConstraints;
                }
                if (val.isRightVariable() && !val.isLeftPrimitive()) {
                    newConstraints.add(InferenceRuleType.copyBound(val, 1.EQUALITY));
                    return newConstraints;
                }
                if (val.isLeftClassOrInterface() && val.isRightClassOrInterface() && val.leftProper().hasSameErasureAs(val.rightProper())) {
                    JavaTypeDefinition right = val.rightProper();
                    JavaTypeDefinition left = val.leftProper();
                    for (int index = 0; index < right.getTypeParameterCount(); ++index) {
                        newConstraints.add(new Constraint(left.getGenericType(index), right.getGenericType(index), EQUALITY));
                    }
                    return newConstraints;
                }
                if (val.isLeftArray() && val.isRightArray()) {
                    newConstraints.add(new Constraint(val.leftProper().getComponentType(), val.rightProper().getComponentType(), EQUALITY));
                    return newConstraints;
                }
                return null;
            }
            return null;
        }
    }
    ,
    SUBTYPE{

        @Override
        public List<BoundOrConstraint> reduce(BoundOrConstraint val) {
            ArrayList<BoundOrConstraint> newConstraints = new ArrayList<BoundOrConstraint>();
            if (val.isLeftProper() && val.isRightProper()) {
                if (MethodTypeResolution.isSubtypeable(val.rightProper(), val.leftProper())) {
                    return newConstraints;
                }
                return null;
            }
            if (val.isLeftNull()) {
                return newConstraints;
            }
            if (val.isRightNull()) {
                return null;
            }
            if (val.isLeftVariable()) {
                newConstraints.add(InferenceRuleType.copyBound(val, 2.SUBTYPE));
                return newConstraints;
            }
            if (val.isRightVariable()) {
                newConstraints.add(InferenceRuleType.copyBound(val, 2.SUBTYPE));
                return newConstraints;
            }
            return null;
        }
    }
    ,
    LOOSE_INVOCATION{

        @Override
        public List<BoundOrConstraint> reduce(BoundOrConstraint val) {
            ArrayList<BoundOrConstraint> newConstraints = new ArrayList<BoundOrConstraint>();
            if (val.isLeftProper() && val.isRightProper()) {
                if (MethodTypeResolution.isMethodConvertible(val.rightProper(), val.leftProper())) {
                    return newConstraints;
                }
                return null;
            }
            if (val.isLeftPrimitive()) {
                if (val.rightProper() != null) {
                    newConstraints.add(new Constraint(MethodTypeResolution.boxPrimitive(val.leftProper()), val.rightProper(), LOOSE_INVOCATION));
                } else {
                    newConstraints.add(new Constraint(MethodTypeResolution.boxPrimitive(val.leftProper()), val.rightVariable(), LOOSE_INVOCATION));
                }
                return newConstraints;
            }
            if (val.isRightPrimitive()) {
                if (val.leftProper() != null) {
                    newConstraints.add(new Constraint(val.leftProper(), MethodTypeResolution.boxPrimitive(val.rightProper()), EQUALITY));
                } else {
                    newConstraints.add(new Constraint(val.leftVariable(), MethodTypeResolution.boxPrimitive(val.rightProper()), EQUALITY));
                }
                return newConstraints;
            }
            newConstraints.add(InferenceRuleType.copyConstraint(val, 3.SUBTYPE));
            return newConstraints;
        }
    }
    ,
    CONTAINS{

        @Override
        public List<BoundOrConstraint> reduce(BoundOrConstraint val) {
            ArrayList<BoundOrConstraint> newConstraints = new ArrayList<BoundOrConstraint>();
            if (val.isRightType() && val.isLeftType()) {
                newConstraints.add(InferenceRuleType.copyConstraint(val, 4.EQUALITY));
                return newConstraints;
            }
            return null;
        }
    };


    private static Bound copyBound(BoundOrConstraint val, InferenceRuleType rule) {
        if (val.leftProper() != null) {
            if (val.rightProper() != null) {
                return new Bound(val.leftProper(), val.rightProper(), rule);
            }
            return new Bound(val.leftProper(), val.rightVariable(), rule);
        }
        if (val.rightProper() != null) {
            return new Bound(val.leftVariable(), val.rightProper(), rule);
        }
        return new Bound(val.leftVariable(), val.rightVariable(), rule);
    }

    private static Constraint copyConstraint(BoundOrConstraint val, InferenceRuleType rule) {
        if (val.leftProper() != null) {
            if (val.rightProper() != null) {
                return new Constraint(val.leftProper(), val.rightProper(), rule);
            }
            return new Constraint(val.leftProper(), val.rightVariable(), rule);
        }
        if (val.rightProper() != null) {
            return new Constraint(val.leftVariable(), val.rightProper(), rule);
        }
        return new Constraint(val.leftVariable(), val.rightVariable(), rule);
    }

    public abstract List<BoundOrConstraint> reduce(BoundOrConstraint var1);
}

