/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.performance.ConsecutiveLiteralAppendsRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;

public class UseStringBufferLengthRule
extends AbstractJavaRule {
    private Set<NameDeclaration> alreadySeen = new HashSet<NameDeclaration>();

    @Override
    public Object visit(ASTMethodDeclaration acu, Object data) {
        this.alreadySeen.clear();
        return super.visit(acu, data);
    }

    @Override
    public Object visit(ASTName decl, Object data) {
        if (!decl.getImage().endsWith("toString")) {
            return super.visit(decl, data);
        }
        NameDeclaration nd = decl.getNameDeclaration();
        if (nd == null) {
            return super.visit(decl, data);
        }
        if (this.alreadySeen.contains(nd) || !(nd instanceof VariableNameDeclaration) || !ConsecutiveLiteralAppendsRule.isStringBuilderOrBuffer(((VariableNameDeclaration)nd).getDeclaratorId())) {
            return super.visit(decl, data);
        }
        this.alreadySeen.add(nd);
        if (this.isViolation(decl)) {
            this.addViolation(data, (Node)decl);
        }
        return super.visit(decl, data);
    }

    private boolean isViolation(ASTName decl) {
        JavaNode parent = ((JavaNode)decl.getParent()).getParent();
        if (parent.getNumChildren() == 4 && ((ASTName)parent.getChild(0).getFirstChildOfType(ASTName.class)).getImage().endsWith(".toString")) {
            return this.isEqualsViolation((Node)parent) || this.isLengthViolation((Node)parent);
        }
        return false;
    }

    private boolean isEqualsViolation(Node parent) {
        Node primarySuffix;
        List methodCalls;
        if (parent.getChild(2).hasImageEqualTo("equals") && (methodCalls = (primarySuffix = parent.getChild(3)).findDescendantsOfType(ASTArgumentList.class)).size() == 1 && ((ASTArgumentList)methodCalls.get(0)).size() == 1) {
            ASTExpression firstArgument = (ASTExpression)((ASTArgumentList)primarySuffix.getChild(0).getFirstChildOfType(ASTArgumentList.class)).findChildrenOfType(ASTExpression.class).get(0);
            List<ASTLiteral> literals = firstArgument.findDescendantsOfType(ASTLiteral.class);
            if (literals.isEmpty()) {
                literals = this.findLiteralsInVariableInitializer(firstArgument);
            }
            return literals.size() == 1 && literals.get(0).hasImageEqualTo("\"\"");
        }
        return false;
    }

    private List<ASTLiteral> findLiteralsInVariableInitializer(ASTExpression firstArgument) {
        ASTVariableDeclarator declarator;
        ASTVariableDeclaratorId varId;
        NameDeclaration nameDeclaration;
        List varAccess = firstArgument.findDescendantsOfType(ASTName.class);
        if (varAccess.size() == 1 && (nameDeclaration = ((ASTName)varAccess.get(0)).getNameDeclaration()) != null && nameDeclaration.getNode() instanceof ASTVariableDeclaratorId && (varId = (ASTVariableDeclaratorId)nameDeclaration.getNode()).isFinal() && varId.getParent() instanceof ASTVariableDeclarator && (declarator = (ASTVariableDeclarator)varId.getParent()).getInitializer() != null) {
            return declarator.getInitializer().findDescendantsOfType(ASTLiteral.class);
        }
        return Collections.emptyList();
    }

    private boolean isLengthViolation(Node parent) {
        return parent.getChild(2).hasImageEqualTo("length");
    }
}

