/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTableFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.DynamicTypeNameFactory;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;

public class FlowInterviewTypeInfo
extends AbstractTypeInfo {
    private final String id;

    private FlowInterviewTypeInfo(Builder builder) {
        super(builder);
        assert (TypeInfoEquivalence.isEquivalent(this.parents().superType(), InternalTypeInfos.FLOW_INTERVIEW));
        this.id = builder.id;
    }

    public static Builder builder() {
        return new Builder();
    }

    @SfdcCalled
    public String getId() {
        return this.id;
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, FlowInterviewTypeInfo> {
        private String flowName;
        private String id;

        private Builder() {
            this.setFields(new StandardFieldTable());
        }

        public Builder setFlowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        @SfdcCalled
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public FlowInterviewTypeInfo build() {
            assert (this.flowName != null) : "Flow name must be defined";
            this.setApexName(DynamicTypeNameFactory.createFlowInterviewApexName(this.getNamespace(), this.flowName));
            this.setBytecodeName(DynamicTypeNameFactory.createFlowInterviewBytecodeName(this.getNamespace(), this.flowName));
            Initializer<MethodTable, TypeInfo> methods = Initializers.memoize(type -> MethodTableFactory.newMethodTableWithSuperTypeVirtualMethodTable(type.parents().superType(), StandardMethodInfo.builder().setDefiningType((TypeInfo)type).setName("<init>").setConstructor().setGenerated(Generated.BUILT_IN).setModifiers(ModifierGroups.ONLY_GLOBAL).setNamedParameterTypes(ReifiedTypeInfos.STRING_TO_OBJECT_MAP).build()));
            this.setBasicType(BasicType.FLOW_INTERVIEW);
            this.setUnitType(UnitType.CLASS);
            this.setModifiers(ModifierGroups.ONLY_GLOBAL);
            this.setMethods(methods);
            return new FlowInterviewTypeInfo(this);
        }
    }
}

