/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.WeakStringInterner;
import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.ast.ParameterRef;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.ParameterUtil;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import apex.jorje.semantic.symbol.type.reference.TypeReferences;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Optional;

public class StandardMethodInfoBuilder {
    private Generated generated;
    private TypeInfo definingType;
    private Identifier inputName;
    private ModifierGroup modifiers;
    private List<Parameter> parameters = ImmutableList.of();
    private TypeReference returnType = TypeReferences.VOID;
    private InvocationType invocationType = null;
    private Signature emitSignature;
    private JavaSfdcOnlyAnnotation javaSfdcOnlyAnnotation = null;
    private boolean isPropertyAccessor = false;
    private boolean isConstructor;
    private ProfilingType profilingType = ProfilingType.NONE;
    private boolean isDuckTyped;
    private List<BuiltInMethodValidator> validators = ImmutableList.of();
    private DmlOperation dmlOperation = DmlOperation.NONE;

    StandardMethodInfoBuilder() {
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("definingType", this.definingType).add("generated", (Object)this.generated).add("inputName", this.inputName).add("modifiers", this.modifiers).add("parameters", this.parameters).add("returnType", this.returnType).add("invocationType", (Object)this.invocationType).add("emitSignature", this.emitSignature).add("javaSfdcOnlyAnnotation", this.javaSfdcOnlyAnnotation).add("isPropertyAccessor", this.isPropertyAccessor).add("isConstructor", this.isConstructor).add("profilingType", (Object)this.profilingType).add("isDuckTyped", this.isDuckTyped).add("validators", this.validators).toString();
    }

    public MethodInfo build() {
        assert (this.definingType != null) : "no defining type";
        assert (this.inputName != null) : "no inputName";
        assert (this.modifiers != null) : "no modifiers";
        this.generated = Optional.ofNullable(this.generated).orElse(Generated.USER);
        this.invocationType = this.modifiers.has(ModifierTypeInfos.STATIC) ? InvocationType.STATIC : (this.isConstructor || this.isPropertyAccessor ? InvocationType.SPECIAL : InvocationType.VIRTUAL);
        return new StandardMethodInfo(this);
    }

    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    public StandardMethodInfoBuilder setModifiers(ModifierGroup modifiers) {
        assert (this.modifiers == null);
        assert (modifiers != null);
        this.modifiers = modifiers;
        return this;
    }

    JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.javaSfdcOnlyAnnotation;
    }

    public StandardMethodInfoBuilder setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation javaSfdcOnlyAnnotation) {
        this.javaSfdcOnlyAnnotation = javaSfdcOnlyAnnotation;
        return this;
    }

    public Location getLoc() {
        return this.inputName.getLoc();
    }

    public Signature getEmitSignature() {
        return this.emitSignature;
    }

    public StandardMethodInfoBuilder setEmitSignature(Signature signature) {
        this.emitSignature = signature;
        return this;
    }

    public Identifier getName() {
        return this.inputName;
    }

    public StandardMethodInfoBuilder setName(String name) {
        return this.setName(Identifiers.newIdentifier(WeakStringInterner.get().intern(name)));
    }

    public StandardMethodInfoBuilder setName(Identifier name) {
        this.inputName = name;
        return this;
    }

    public StandardMethodInfoBuilder setEmitSignature(String name, TypeInfo returnType, TypeInfo ... parameterTypes) {
        assert (parameterTypes.length == this.parameters.size());
        this.emitSignature = SignatureFactory.create(name, returnType, parameterTypes);
        return this;
    }

    public StandardMethodInfoBuilder setHiddenParameterTypes(TypeInfo ... parameterTypes) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toHidden(this.definingType, MoreLists.asImmutableList(parameterTypes)));
    }

    public StandardMethodInfoBuilder setNamedParameterTypes(List<TypeInfo> parameterTypes) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toNamed(this.definingType, parameterTypes));
    }

    public StandardMethodInfoBuilder setNamedParameterTypes(TypeInfo ... parameterTypes) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toNamed(this.definingType, MoreLists.asImmutableList(parameterTypes)));
    }

    public StandardMethodInfoBuilder setConstructor() {
        this.returnType = TypeReferences.VOID;
        this.inputName = Identifiers.newIdentifier("<init>");
        this.isConstructor = true;
        return this;
    }

    public StandardMethodInfoBuilder setPropertyAccessor() {
        this.isPropertyAccessor = true;
        return this;
    }

    public Generated getGenerated() {
        return this.generated;
    }

    public StandardMethodInfoBuilder setGenerated(Generated generated) {
        assert (this.generated == null);
        this.generated = generated;
        return this;
    }

    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    public StandardMethodInfoBuilder setDefiningType(TypeInfo definingType) {
        this.definingType = definingType;
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @SfdcCalled
    public StandardMethodInfoBuilder setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public StandardMethodInfoBuilder setParameters(Parameter ... parameters) {
        return this.setParameters(MoreLists.asImmutableList(parameters));
    }

    public StandardMethodInfoBuilder copyParameters(List<Parameter> parameters) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.copy(this.definingType, parameters));
    }

    public StandardMethodInfoBuilder setParameterRefs(List<ParameterRef> parameters) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toParameter(this.definingType, parameters));
    }

    public TypeReference getReturnType() {
        return this.returnType;
    }

    public StandardMethodInfoBuilder setReturnType(Optional<TypeRef> type) {
        this.returnType = type.map(TypeReferences::createResolvable).orElse(TypeReferences.VOID);
        this.isConstructor = !type.isPresent();
        return this;
    }

    public StandardMethodInfoBuilder setReturnType(TypeInfo returnType) {
        this.returnType = TypeReferences.createResolved(returnType);
        return this;
    }

    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    @SfdcCalled
    public StandardMethodInfoBuilder setConstructor(boolean isConstructor) {
        if (isConstructor) {
            this.setConstructor();
        }
        return this;
    }

    public boolean isPropertyAccessor() {
        return this.isPropertyAccessor;
    }

    ProfilingType getProfilingType() {
        return this.profilingType;
    }

    public StandardMethodInfoBuilder setProfilingType(ProfilingType profilingType) {
        this.profilingType = profilingType;
        return this;
    }

    public StandardMethodInfoBuilder setDuckTyped() {
        this.isDuckTyped = true;
        return this;
    }

    boolean isDuckTyped() {
        return this.isDuckTyped;
    }

    public StandardMethodInfoBuilder setValidators(BuiltInMethodValidator ... validators) {
        return this.setValidators(MoreLists.asImmutableList(validators));
    }

    public List<BuiltInMethodValidator> getValidators() {
        return this.validators;
    }

    @SfdcCalled
    public StandardMethodInfoBuilder setValidators(List<BuiltInMethodValidator> validators) {
        this.validators = MoreLists.toImmutableList(validators);
        return this;
    }

    DmlOperation getDmlOperation() {
        return this.dmlOperation;
    }

    public StandardMethodInfoBuilder setDmlOperation(DmlOperation dmlOperation) {
        this.dmlOperation = dmlOperation;
        return this;
    }
}

