/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.property.rule;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.type.AnnotationProperty;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreSets;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class AnnotationPropertyRules {
    public static final ImmutableSet<AnnotationProperty.Type> ALL_TYPES_ALLOWED = ImmutableSet.copyOf(AnnotationProperty.Type.values());

    private AnnotationPropertyRules() {
    }

    public static AnnotationPropertyRule lessThanOrEqual(int value) {
        return new LessThanOrEqual(value);
    }

    public static AnnotationPropertyRule greaterThanOrEqual(int value) {
        return new GreaterThanOrEqual(value);
    }

    public static AnnotationPropertyRule validStrings(Set<String> values) {
        return new ValidStrings(MoreSets.toImmutableCaseInsensitiveSet(values));
    }

    public static AnnotationPropertyRule permGuardedString(String value, PlaceholderOrgPerm orgPerm) {
        return new PermGuardedString(value, orgPerm);
    }

    public static AnnotationPropertyRule permGuarded(PlaceholderOrgPerm orgPerm) {
        return new PermGuardedProperty(orgPerm);
    }

    public static AnnotationPropertyRule minVersion(Version version) {
        return new MinVersion(version);
    }

    public static AnnotationPropertyRule maxVersion(Version version) {
        return new MaxVersion(version);
    }

    public static AnnotationPropertyRule allowedElements(Element ... elements) {
        return new AllowedElementsRule(MoreSets.newLinkedHashSet(elements));
    }

    public static AnnotationPropertyRule validApiVersion() {
        return new ValidApiVersion();
    }

    public static AnnotationPropertyRule gatedRule(AnnotationPropertyRule rule, Predicate<AccessEvaluator> gate) {
        return new GatedRule(rule, gate);
    }

    public static AnnotationPropertyRule notAllowed() {
        return new NotAllowedRule();
    }

    public static AnnotationPropertyRule validConfigurationEditorName() {
        return InvocableMethodConfigurationEditorRule.get();
    }

    private static class InvocableMethodConfigurationEditorRule
    implements AnnotationPropertyRule {
        private static final InvocableMethodConfigurationEditorRule INSTANCE = new InvocableMethodConfigurationEditorRule();

        private InvocableMethodConfigurationEditorRule() {
        }

        public static InvocableMethodConfigurationEditorRule get() {
            return INSTANCE;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ALL_TYPES_ALLOWED;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            String value = parameter.getStringValue();
            if (Strings.isNullOrEmpty(value) || !context.getSymbols().getAccessEvaluator().doesLightningWebComponentExist(value)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.invalid.lightning.web.component.name", value));
            }
        }
    }

    private static class GatedRule
    implements AnnotationPropertyRule {
        private final AnnotationPropertyRule rule;
        private final Predicate<AccessEvaluator> gate;

        private GatedRule(AnnotationPropertyRule rule, Predicate<AccessEvaluator> gate) {
            this.rule = rule;
            this.gate = gate;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ALL_TYPES_ALLOWED;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            if (!this.gate.test(context.getSymbols().getAccessEvaluator())) {
                this.rule.validate(context, parameter);
            }
        }
    }

    private static class AllowedElementsRule
    implements AnnotationPropertyRule {
        private final Set<Element> elements;

        private AllowedElementsRule(Set<Element> elements) {
            assert (!elements.isEmpty()) : "illegal allowed elements rule";
            this.elements = elements;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ALL_TYPES_ALLOWED;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            if (!parameter.isDefault() && !this.elements.contains((Object)context.getElement())) {
                context.addError(I18nSupport.getLabel("annotation.property.is.not.allowed", new Object[]{parameter.getProperty().getName(), parameter.getAnnotationType().getApexName(), context.getElement()}));
            }
        }
    }

    private static class NotAllowedRule
    implements AnnotationPropertyRule {
        private NotAllowedRule() {
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ALL_TYPES_ALLOWED;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            AnnotationProperty property = parameter.getProperty();
            if (!Locations.isReal(parameter.getLoc())) {
                return;
            }
            context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.not.supported", property.getName(), parameter.getAnnotationType()));
        }
    }

    private static class GreaterThanOrEqual
    extends IntegerRule {
        private GreaterThanOrEqual(int value) {
            super(value);
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            int actual = parameter.getIntegerValue();
            if (actual < this.getValue()) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.greater.than.or.equal", parameter.getProperty().getName(), parameter.getAnnotationType(), this.getValue(), actual));
            }
        }
    }

    private static class LessThanOrEqual
    extends IntegerRule {
        private LessThanOrEqual(int value) {
            super(value);
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            int actual = parameter.getIntegerValue();
            if (actual > this.getValue()) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.less.than.or.equal", parameter.getProperty().getName(), parameter.getAnnotationType(), this.getValue(), actual));
            }
        }
    }

    private static class ValidApiVersion
    implements AnnotationPropertyRule {
        private ValidApiVersion() {
        }

        @Override
        public final Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.of(AnnotationProperty.Type.INTEGER);
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            int actual = parameter.getIntegerValue();
            Version version = Version.fromInternal(actual);
            if (version == null) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.invalid.api.version", parameter.getProperty().getName(), parameter.getAnnotationType(), actual));
            }
        }
    }

    private static abstract class IntegerRule
    implements AnnotationPropertyRule {
        private final int value;

        private IntegerRule(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        @Override
        public final Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.of(AnnotationProperty.Type.INTEGER);
        }
    }

    private static class PermGuardedString
    extends StringRule {
        private final String value;
        private final PlaceholderOrgPerm orgPerm;

        private PermGuardedString(String value, PlaceholderOrgPerm orgPerm) {
            this.value = value;
            this.orgPerm = orgPerm;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            String actual = parameter.getStringValue();
            if (!context.getSymbols().getAccessEvaluator().hasPermission(this.orgPerm) && this.value.equalsIgnoreCase(actual)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.invalid.perm.value", parameter.getProperty().getName(), parameter.getAnnotationType(), actual));
            }
        }
    }

    private static class ValidStrings
    extends StringRule {
        private final Set<String> values;

        private ValidStrings(Set<String> values) {
            this.values = values;
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            String actual = parameter.getStringValue();
            if (!this.values.contains(actual)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.bad.string.value", parameter.getProperty().getName(), parameter.getAnnotationType(), actual));
            }
        }
    }

    private static abstract class StringRule
    implements AnnotationPropertyRule {
        private StringRule() {
        }

        @Override
        public final Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.of(AnnotationProperty.Type.STRING);
        }
    }

    private static class PermGuardedProperty
    implements AnnotationPropertyRule {
        private final PlaceholderOrgPerm orgPerm;

        private PermGuardedProperty(PlaceholderOrgPerm orgPerm) {
            this.orgPerm = orgPerm;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.copyOf(AnnotationProperty.Type.values());
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            String value;
            String defaultValue;
            if (parameter.getProperty().hasDefaultValue() && Objects.equals(defaultValue = parameter.getProperty().getDefaultValue().get(context.getVersion()).toString(), value = parameter.getValueAsString())) {
                return;
            }
            if (!context.getSymbols().getAccessEvaluator().hasPermission(this.orgPerm)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.not.supported", parameter.getProperty().getName(), parameter.getAnnotationType()));
            }
        }
    }

    private static class MaxVersion
    implements AnnotationPropertyRule {
        private final Version version;

        private MaxVersion(Version version) {
            this.version = version;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.copyOf(AnnotationProperty.Type.values());
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            Version current = context.getVersion();
            if (Locations.isReal(parameter.getLoc()) && current.isGreaterThan(this.version)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.max.version", parameter.getProperty().getName(), parameter.getAnnotationType(), this.version.getExternal()));
            }
        }
    }

    private static class MinVersion
    implements AnnotationPropertyRule {
        private final Version version;

        private MinVersion(Version version) {
            this.version = version;
        }

        @Override
        public Set<AnnotationProperty.Type> getAllowedTypes() {
            return ImmutableSet.copyOf(AnnotationProperty.Type.values());
        }

        @Override
        public void validate(AnnotationContext context, AnnotationParameter parameter) {
            Version current = context.getVersion();
            if (Locations.isReal(parameter.getLoc()) && current.isLessThan(this.version)) {
                context.getErrors().markInvalid((AstNode)parameter, I18nSupport.getLabel("annotation.property.min.version", parameter.getProperty().getName(), parameter.getAnnotationType(), this.version.getExternal()));
            }
        }
    }
}

