/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class PolymorphicTypes {
    private static final VariableVisitor<List<TypeInfo>, Void> GET_POLYMORPHIC_TYPES_FROM_VARIABLE = new VariableVisitor.Default<List<TypeInfo>, Void>(){

        @Override
        protected List<TypeInfo> _default(Variable info, Void context) {
            return ImmutableList.of();
        }

        @Override
        public List<TypeInfo> visit(SObjectFieldInfo info, Void context) {
            return info.getPolymorphicTypes();
        }
    };
    private static final AstVisitor<ValueScope<List<TypeInfo>>> GET_POLYMORPHIC_TYPES_FROM_EXPRESSION = new AstVisitor<ValueScope<List<TypeInfo>>>(){

        @Override
        public void visitEnd(VariableExpression node, ValueScope<List<TypeInfo>> scope) {
            if (node.getVariable().getDefiningType().getBasicType() == BasicType.SOBJECT && node.getVariable().getMemberType() == Member.Type.FIELD) {
                scope.setValue((List<TypeInfo>)node.getVariable().accept(GET_POLYMORPHIC_TYPES_FROM_VARIABLE, VariableVisitor.Context.NONE));
            }
        }
    };

    private PolymorphicTypes() {
    }

    public static boolean isAssignable(TypeInfo definingType, Expression input, TypeInfo targetType) {
        List<TypeInfo> polymorphicTypes = PolymorphicTypes.getPolymorphicTypes(input);
        if (polymorphicTypes.isEmpty()) {
            return Distance.get().canAssign(definingType, input.getType(), targetType);
        }
        for (TypeInfo polymorphicType : polymorphicTypes) {
            if (!Distance.get().canAssign(definingType, polymorphicType, targetType)) continue;
            return true;
        }
        return Distance.get().canAssign(definingType, input.getType(), targetType);
    }

    public static boolean isAssignable(TypeInfo definingType, TypeInfo inputType, Expression target) {
        List<TypeInfo> polymorphicTypes = PolymorphicTypes.getPolymorphicTypes(target);
        if (polymorphicTypes.isEmpty()) {
            return Distance.get().canAssign(definingType, inputType, target.getType());
        }
        for (TypeInfo polymorphicType : polymorphicTypes) {
            if (!Distance.get().canAssign(definingType, inputType, polymorphicType)) continue;
            return true;
        }
        return Distance.get().canAssign(definingType, inputType, target.getType());
    }

    public static List<TypeInfo> getPolymorphicTypes(Expression right) {
        return ValueScope.evaluate(right, GET_POLYMORPHIC_TYPES_FROM_EXPRESSION, ImmutableList.of());
    }
}

