/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.lsp.impl.codeActions.ExtractConstantHandler;
import apex.jorje.lsp.impl.codeActions.ExtractLocalVariableHandler;
import apex.jorje.lsp.impl.utils.ExtractUtil;
import apex.jorje.lsp.impl.utils.IndexUtil;
import apex.jorje.lsp.impl.visitors.CodeActionScope;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.ClassRefExpression;
import apex.jorje.semantic.ast.expression.EmptyReferenceExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.JavaMethodCallExpression;
import apex.jorje.semantic.ast.expression.JavaVariableExpression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.TernaryExpression;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;

public class CodeActionVisitor
extends AstVisitor<CodeActionScope> {
    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(ArrayLoadExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(ArrayStoreExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(BinaryExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(BooleanExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(CastExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(ClassRefExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(InstanceOfExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(JavaMethodCallExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(JavaVariableExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(LiteralExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
                scope.addCodeAction(this.getCodeActionExtractConstant(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(MethodCallExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (EmptyReferenceExpression.isEmptyReference(node.getReferenceContext()) && this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewKeyValueObjectExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewListInitExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewListLiteralExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewMapInitExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewMapLiteralExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewObjectExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewSetInitExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(NewSetLiteralExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(PrefixExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
                scope.addCodeAction(this.getCodeActionExtractConstant(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(SoqlExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(SoslExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(TernaryExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(TriggerVariableExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    @Override
    public void visitEnd(VariableExpression node, CodeActionScope scope) {
        if (!scope.getNode().isPresent()) {
            super.visitEnd(node, scope);
            if (EmptyReferenceExpression.isEmptyReference(node.getReferenceContext()) && ExtractUtil.canExtract(node).booleanValue() && this.checkSpanMatch(node, scope)) {
                scope.addCodeAction(this.getCodeActionExtractVariable(node, scope));
            }
        }
    }

    private boolean checkSpanMatch(Expression node, CodeActionScope scope) {
        if (scope.getStartOffset() == scope.getEndOffset()) {
            if (node.getLoc().getStartIndex() <= scope.getStartOffset() && IndexUtil.computeEndOffset(scope.getSource(), node) >= scope.getStartOffset()) {
                scope.setNode(node);
                return true;
            }
        } else if (node.getLoc().getStartIndex() == scope.getStartOffset() && IndexUtil.computeEndOffset(scope.getSource(), node) == scope.getEndOffset()) {
            scope.setNode(node);
            return true;
        }
        return false;
    }

    private Optional<CodeAction> getCodeActionExtractConstant(Expression node, CodeActionScope scope) {
        return new ExtractConstantHandler(node, scope).getCodeAction();
    }

    private Optional<CodeAction> getCodeActionExtractVariable(Expression node, CodeActionScope scope) {
        return new ExtractLocalVariableHandler(node, scope).getCodeAction();
    }
}

