/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.data.Locations;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.symbols.CachingSymbolProvider;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.common.TestQueryValidators;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.ValidationSettings;
import apex.jorje.semantic.compiler.parser.ParserEngine;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.NoopCompilerProgressCallback;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardCompilerService
implements ApexCompilerService {
    private static final Logger logger = LoggerFactory.getLogger(StandardCompilerService.class);
    private final CachingSymbolProvider symbolProvider;
    private final AccessEvaluator accessEvaluator;
    private final QueryValidator queryValidator;
    private ApexCompiler compiler;
    private final ApexDocumentService docService;
    private CodeUnit mostRecentCodeUnit;
    private Map<String, CodeUnit> codeUnitCache;

    @Inject
    public StandardCompilerService(CachingSymbolProvider symbolProvider, ApexDocumentService docService) {
        this.symbolProvider = symbolProvider;
        this.accessEvaluator = new TestAccessEvaluator();
        this.queryValidator = new TestQueryValidators.Noop();
        this.docService = docService;
        this.codeUnitCache = new HashMap<String, CodeUnit>();
        Locations.useIndexFactory();
    }

    @Override
    public synchronized List<CodeUnit> compile(List<SourceFile> sourceFiles) {
        this.compiler = this.createCompiler(sourceFiles, null, ParserEngine.HiddenTokenBehavior.IGNORE);
        return this.compiler.compile(CompilerStage.ADDITIONAL_VALIDATE);
    }

    @Override
    public synchronized CodeUnit compile(Document document) {
        return this.fetchCodeUnit(document, null);
    }

    @Override
    public synchronized CodeUnit compile(Document document, AstVisitor<AdditionalPassScope> visitor) {
        return this.fetchCodeUnit(document, visitor);
    }

    @Override
    public synchronized CodeUnit compile(Document document, String namespace) {
        return this.compile(this.docsToSources(ImmutableList.of(document), namespace), null, ParserEngine.HiddenTokenBehavior.IGNORE).get(0);
    }

    @Override
    public synchronized List<CodeUnit> compile(List<Document> documents, ParserEngine.HiddenTokenBehavior hiddenTokenBehavior) {
        return this.compile(this.docsToSources(documents), null, hiddenTokenBehavior);
    }

    @Override
    public synchronized void cacheCodeUnitForIndexerStartup(CodeUnit codeUnit) {
        this.codeUnitCache.put(codeUnit.getSourceFile().getKnownName(), codeUnit);
    }

    @Override
    public synchronized CodeUnit getCachedCodeUnitForIndexerStartup(String name) {
        return this.codeUnitCache.get(name);
    }

    @Override
    public synchronized void clearIndexerStartupCache() {
        this.codeUnitCache.clear();
    }

    private synchronized List<CodeUnit> compile(List<SourceFile> sourceFiles, AstVisitor<AdditionalPassScope> visitor, ParserEngine.HiddenTokenBehavior hiddenTokenBehavior) {
        this.compiler = this.createCompiler(sourceFiles, visitor, hiddenTokenBehavior);
        return this.compiler.compile(CompilerStage.ADDITIONAL_VALIDATE);
    }

    @Override
    public synchronized SymbolResolver getSymbolResolver() {
        if (this.compiler == null) {
            return new StandardSymbolResolver(this.createCompiler(ImmutableList.of(), null, ParserEngine.HiddenTokenBehavior.IGNORE));
        }
        return this.compiler.getCompilerContext().getSymbolResolver();
    }

    @Override
    public synchronized void clearCache() {
        this.mostRecentCodeUnit = null;
    }

    CodeUnit getMostRecentCodeUnit() {
        return this.mostRecentCodeUnit;
    }

    void setMostRecentCodeUnit(CodeUnit codeUnit) {
        this.mostRecentCodeUnit = codeUnit;
    }

    private synchronized ApexCompiler createCompiler(List<SourceFile> sources, AstVisitor<AdditionalPassScope> visitor, ParserEngine.HiddenTokenBehavior hiddenTokenBehavior) {
        CompilationInput input = new CompilationInput(sources, this.symbolProvider, this.accessEvaluator, this.queryValidator, visitor, NoopCompilerProgressCallback.get());
        ValidationSettings validationSettings = ValidationSettings.builder().setValidationBehavior(ValidationSettings.ValidationBehavior.COLLECT_MULTIPLE_ERRORS).build();
        return ApexCompiler.builder().setInput(input).setValidationSettings(validationSettings).setHiddenTokenBehavior(hiddenTokenBehavior).build();
    }

    synchronized CodeUnit fetchCodeUnit(Document document, AstVisitor<AdditionalPassScope> visitor) {
        if (this.mostRecentCodeUnit == null || Objects.equals(this.mostRecentCodeUnit.getSourceFile().getKnownName(), "file:///insertedDoc.cls") || !Objects.equals(this.mostRecentCodeUnit.getSourceFile().getKnownName(), document.getUri().toString())) {
            this.mostRecentCodeUnit = this.compile(this.docsToSources(ImmutableList.of(document)), visitor, ParserEngine.HiddenTokenBehavior.COLLECT_COMMENTS).get(0);
        } else if (visitor != null) {
            this.mostRecentCodeUnit.additionalValidate(visitor);
        }
        return this.mostRecentCodeUnit;
    }

    private synchronized List<SourceFile> docsToSources(List<Document> documents) {
        return documents.stream().map(doc -> this.docToSource((Document)doc, this.docService.retrieveNamespace(doc.getUri()))).collect(Collectors.toList());
    }

    private synchronized List<SourceFile> docsToSources(List<Document> documents, String namespace) {
        return documents.stream().map(doc -> this.docToSource((Document)doc, namespace)).collect(Collectors.toList());
    }

    private synchronized SourceFile docToSource(Document doc, String namespace) {
        return SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).setNamespace(Namespaces.create(namespace)).setFileBased(this.docService.isFauxClass(doc.getUri())).setTrusted(this.docService.isFauxClass(doc.getUri())).build();
    }
}

