/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.common.base.MoreStrings;
import apex.common.collect.MoreIterables;
import apex.jorje.data.Identifier;
import apex.jorje.data.ast.AnnotationParameter;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.ParameterRef;
import java.util.List;
import java.util.stream.Collectors;

public class PrinterBlocks {
    private static final PrinterBlocks INSTANCE = new PrinterBlocks();
    private static final AnnotationValue.MatchBlock<String> KEY_VALUE = new AnnotationValue.MatchBlock<String>(){

        @Override
        public String _case(AnnotationValue.TrueAnnotationValue x) {
            return "true";
        }

        @Override
        public String _case(AnnotationValue.FalseAnnotationValue x) {
            return "false";
        }

        @Override
        public String _case(AnnotationValue.StringAnnotationValue x) {
            return "'" + x.value + "'";
        }
    };
    private static final AnnotationParameter.MatchBlock<String> ANNOTATION_PARAMETER = new AnnotationParameter.MatchBlock<String>(){

        @Override
        public String _case(AnnotationParameter.AnnotationString x) {
            return "'" + x.value + "'";
        }

        @Override
        public String _case(AnnotationParameter.AnnotationKeyValue x) {
            return x.key.getValue() + "=" + (String)x.value.match(KEY_VALUE);
        }
    };
    private static final Modifier.MatchBlock<String> MODIFIER = new Modifier.MatchBlock<String>(){

        @Override
        public String _case(Modifier.TestMethodModifier x) {
            return "testmethod";
        }

        @Override
        public String _case(Modifier.GlobalModifier x) {
            return "global";
        }

        @Override
        public String _case(Modifier.WebServiceModifier x) {
            return "webservice";
        }

        @Override
        public String _case(Modifier.PublicModifier x) {
            return "public";
        }

        @Override
        public String _case(Modifier.PrivateModifier x) {
            return "private";
        }

        @Override
        public String _case(Modifier.ProtectedModifier x) {
            return "protected";
        }

        @Override
        public String _case(Modifier.WithSharingModifier x) {
            return "with sharing";
        }

        @Override
        public String _case(Modifier.WithoutSharingModifier x) {
            return "without sharing";
        }

        @Override
        public String _case(Modifier.StaticModifier x) {
            return "static";
        }

        @Override
        public String _case(Modifier.TransientModifier x) {
            return "transient";
        }

        @Override
        public String _case(Modifier.AbstractModifier x) {
            return "abstract";
        }

        @Override
        public String _case(Modifier.FinalModifier x) {
            return "final";
        }

        @Override
        public String _case(Modifier.OverrideModifier x) {
            return "override";
        }

        @Override
        public String _case(Modifier.InheritedSharingModifier x) {
            return "inherited sharing";
        }

        @Override
        public String _case(Modifier.VirtualModifier x) {
            return "virtual";
        }

        @Override
        public String _case(Modifier.Annotation x) {
            String parameters = x.parameters.isEmpty() ? "" : x.parameters.stream().map(parameter -> PrinterBlocks.get().print((AnnotationParameter)parameter)).collect(Collectors.joining(" ", "(", ")"));
            return "@" + x.name.getValue() + parameters;
        }
    };

    private PrinterBlocks() {
    }

    public static PrinterBlocks get() {
        return INSTANCE;
    }

    public String print(AnnotationParameter parameter) {
        return parameter.match(ANNOTATION_PARAMETER);
    }

    public String print(Modifier modifier) {
        return modifier.match(MODIFIER);
    }

    public String printDotSeparated(List<Identifier> identifiers) {
        if (identifiers.isEmpty()) {
            return "";
        }
        if (identifiers.size() == 1) {
            return MoreIterables.getFirst(identifiers).getValue();
        }
        return identifiers.stream().map(Identifier::getValue).collect(Collectors.joining("."));
    }

    public String print(List<ParameterRef> parameters) {
        if (parameters.isEmpty()) {
            return "";
        }
        if (parameters.size() == 1) {
            return MoreIterables.getFirst(parameters).toString();
        }
        return parameters.stream().map(Object::toString).collect(MoreStrings.ON_COMMA_AND_SPACE);
    }
}

