/*
 * Decompiled with CFR 0.152.
 */
package apex.common.base;

import apex.common.base.ToLowerCaseFast;
import apex.common.base.ToUpperCaseFast;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class MoreStrings {
    public static final Collector<CharSequence, ?, String> ON_COMMA = Collectors.joining(",");
    public static final Collector<CharSequence, ?, String> ON_NEW_LINE = Collectors.joining("\n");
    public static final Collector<CharSequence, ?, String> ON_COMMA_AND_SPACE = Collectors.joining(", ");
    public static final Collector<CharSequence, ?, String> ON_COLON = Collectors.joining(":");
    public static final Collector<CharSequence, ?, String> ON_COMMA_ENCLOSING_PARENTHESISES = Collectors.joining(",", "(", ")");
    public static final Collector<CharSequence, ?, String> ON_COMMA_AND_SPACE_ENCLOSING_PARENTHESISES = Collectors.joining(", ", "(", ")");
    public static final Collector<CharSequence, ?, String> ON_COMMA_AND_SPACE_ENCLOSING_CURLY_BRACES = Collectors.joining(", ", "{", "}");
    private static final ToLowerCaseFast LOWER_CASE_FAST = ToLowerCaseFast.get();
    private static final ToUpperCaseFast UPPER_CASE_FAST = ToUpperCaseFast.get();

    private MoreStrings() {
    }

    public static String toLowerCase(String string) {
        int length;
        block4: {
            length = string.length();
            for (int firstUpper = 0; firstUpper < length; ++firstUpper) {
                char c = string.charAt(firstUpper);
                if (LOWER_CASE_FAST.canBeFastLowerCased(c) && c == LOWER_CASE_FAST.toLowerCase(c)) {
                    continue;
                }
                break block4;
            }
            return string;
        }
        char[] charArray = string.toCharArray();
        for (int i = firstUpper; i < length; ++i) {
            char c = charArray[i];
            if (!LOWER_CASE_FAST.canBeFastLowerCased(c)) {
                return string.toLowerCase();
            }
            charArray[i] = LOWER_CASE_FAST.toLowerCase(c);
        }
        return new String(charArray);
    }

    public static String toUpperCase(String string) {
        int length;
        block4: {
            length = string.length();
            for (int firstLower = 0; firstLower < length; ++firstLower) {
                char c = string.charAt(firstLower);
                if (UPPER_CASE_FAST.canBeFastUpperCased(c) && c == UPPER_CASE_FAST.toUpperCase(c)) {
                    continue;
                }
                break block4;
            }
            return string;
        }
        char[] charArray = string.toCharArray();
        for (int i = firstLower; i < length; ++i) {
            char c = charArray[i];
            if (!UPPER_CASE_FAST.canBeFastUpperCased(c)) {
                return string.toLowerCase();
            }
            charArray[i] = UPPER_CASE_FAST.toUpperCase(c);
        }
        return new String(charArray);
    }

    public static boolean isLowerCase(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isAlphabetic(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isAlphabetic(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static int lowerCaseHashCode(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < value.length(); ++i) {
            hash = 31 * hash + LOWER_CASE_FAST.toLowerCase(UPPER_CASE_FAST.toUpperCase(value.charAt(i)));
        }
        return hash;
    }

    public static boolean equalsIgnoreCase(String left, String right) {
        int rightLength;
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        int leftLength = left.length();
        return leftLength == (rightLength = right.length()) && MoreStrings.regionMatchesIgnoreCase(left, 0, right, 0, leftLength);
    }

    public static boolean equalsIgnoreCase(char left, char right) {
        return left == right || UPPER_CASE_FAST.toUpperCase(left) == UPPER_CASE_FAST.toUpperCase(right) || LOWER_CASE_FAST.toLowerCase(left) == LOWER_CASE_FAST.toLowerCase(right);
    }

    public static boolean regionMatchesIgnoreCase(String left, int leftOffset, String right, int rightOffset, int length) {
        if (leftOffset < 0 || rightOffset < 0 || (long)leftOffset > (long)left.length() - (long)length || (long)rightOffset > (long)right.length() - (long)length) {
            return false;
        }
        int leftIndex = leftOffset;
        int rightIndex = rightOffset;
        int index = length;
        while (index-- > 0) {
            char rightChar;
            char leftChar;
            if (MoreStrings.equalsIgnoreCase(leftChar = left.charAt(leftIndex++), rightChar = right.charAt(rightIndex++))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(String string, String prefix) {
        Objects.requireNonNull(prefix, "prefix must be non null");
        return string != null && string.startsWith(prefix);
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        Objects.requireNonNull(prefix, "prefix must be non null");
        return MoreStrings.startsWithIgnoreCase(string, prefix, 0);
    }

    public static boolean startsWithIgnoreCase(String string, String prefix, int offset) {
        Objects.requireNonNull(prefix, "prefix must be non null");
        if (string == null) {
            return false;
        }
        int prefixLength = prefix.length();
        if (offset < 0 || offset > string.length() - prefixLength) {
            return false;
        }
        int stringOffset = offset;
        int prefixOffset = 0;
        while (--prefixLength >= 0) {
            char rightChar;
            char leftChar;
            if (MoreStrings.equalsIgnoreCase(leftChar = string.charAt(stringOffset++), rightChar = prefix.charAt(prefixOffset++))) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(String string, String suffix) {
        Objects.requireNonNull(suffix, "suffix must be non null");
        return string != null && string.endsWith(suffix);
    }

    public static boolean endsWithIgnoreCase(String string, String suffix) {
        Objects.requireNonNull(suffix, "suffix must be non null");
        return string != null && MoreStrings.startsWithIgnoreCase(string, suffix, string.length() - suffix.length());
    }
}

