/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

public final class CompositeName {
    private static final CompositeName NIL = new CompositeName(null, null);
    static final String ROOT_PSEUDO_NAME = "";
    public static final String NAME_COMPONENT_SEPARATOR = ".";
    private String head;
    private CompositeName tail;

    private CompositeName(String head, CompositeName tail) {
        this.head = head;
        this.tail = tail;
    }

    private static CompositeName create(String[] components, int startIndex, int total, boolean isAbsolute) {
        if (isAbsolute) {
            return new CompositeName(ROOT_PSEUDO_NAME, CompositeName.create(components, startIndex, total, false));
        }
        if (startIndex == total) {
            return NIL;
        }
        return new CompositeName(components[startIndex], CompositeName.create(components, startIndex + 1, total, false));
    }

    public static CompositeName create(boolean isAbsolute, String[] components) {
        return CompositeName.create(components, 0, components.length, isAbsolute);
    }

    public static CompositeName create(boolean isAbsolute, String[] components, int prefixLength) {
        return CompositeName.create(components, 0, prefixLength, isAbsolute);
    }

    public static CompositeName create(String simpleName) {
        return new CompositeName(simpleName, NIL);
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public String getHead() {
        return this.head;
    }

    public CompositeName getTail() {
        return this.tail;
    }

    private CompositeName matchPrefix(String[] prefix, int currentIndex) {
        if (currentIndex == prefix.length) {
            return this;
        }
        if (prefix[currentIndex].equals(this.head) && this.tail != null) {
            return this.tail.matchPrefix(prefix, currentIndex + 1);
        }
        return null;
    }

    public CompositeName matchPrefix(String[] prefix) {
        return this.matchPrefix(prefix, 0);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Nil";
        }
        return this.head + "::" + this.tail.toString();
    }
}

