/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.util.HS_SA_Support;
import org.openjdk.jol.util.InstrumentationSupport;
import org.openjdk.jol.util.MathUtil;
import org.openjdk.jol.util.sa.impl.compressedrefs.HS_SA_CompressedReferencesResult;
import sun.misc.Unsafe;

public class VMSupport {
    public static final Unsafe U;
    public static final String VM_NAME;
    public static final int ADDRESS_SIZE;
    public static final int REF_SIZE;
    public static final int OBJ_ALIGNMENT;
    public static final int OBJ_HEADER_SIZE;
    public static final int ARRAY_HEADER_SIZE;
    public static final boolean USE_COMPRESSED_REFS;
    public static final long COMPRESSED_REF_BASE;
    public static final int COMPRESSED_REF_SHIFT;
    public static final int OOP_SIZE;
    public static final boolean USE_COMPRESSED_OOP;
    public static final long COMPRESSED_OOP_BASE;
    public static final int COMPRESSED_OOP_SHIFT;
    public static final int KLASS_OOP_SIZE;
    public static final boolean USE_COMPRESSED_KLASS;
    public static final long COMPRESSED_KLASS_BASE;
    public static final int COMPRESSED_KLASS_SHIFT;
    public static final int BOOLEAN_SIZE;
    public static final int BYTE_SIZE;
    public static final int CHAR_SIZE;
    public static final int DOUBLE_SIZE;
    public static final int FLOAT_SIZE;
    public static final int INT_SIZE;
    public static final int LONG_SIZE;
    public static final int SHORT_SIZE;
    private static final ThreadLocal<Object[]> BUFFERS;
    private static final long OBJECT_ARRAY_BASE;

    public static long toNativeAddress(long address) {
        if (USE_COMPRESSED_REFS) {
            return COMPRESSED_REF_BASE + (address << COMPRESSED_REF_SHIFT);
        }
        return address;
    }

    public static long toJvmAddress(long address) {
        if (USE_COMPRESSED_REFS) {
            return (address >> COMPRESSED_REF_SHIFT) - COMPRESSED_REF_BASE;
        }
        return address;
    }

    public static long toNativeOopAddress(long address) {
        if (USE_COMPRESSED_OOP) {
            return COMPRESSED_OOP_BASE + (address << COMPRESSED_OOP_SHIFT);
        }
        return address;
    }

    public static long toJvmOopAddress(long address) {
        if (USE_COMPRESSED_OOP) {
            return (address >> COMPRESSED_OOP_SHIFT) - COMPRESSED_OOP_BASE;
        }
        return address;
    }

    public static long toNativeKlassAddress(long address) {
        if (USE_COMPRESSED_KLASS) {
            return COMPRESSED_KLASS_BASE + (address << COMPRESSED_KLASS_SHIFT);
        }
        return address;
    }

    public static long toJvmKlassAddress(long address) {
        if (USE_COMPRESSED_KLASS) {
            return (address >> COMPRESSED_KLASS_SHIFT) - COMPRESSED_KLASS_BASE;
        }
        return address;
    }

    public static int align(int addr) {
        return MathUtil.align(addr, OBJ_ALIGNMENT);
    }

    public static String vmDetails() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("Running " + ADDRESS_SIZE * 8 + "-bit " + VM_NAME + " VM.");
        String javaSpecVersion = System.getProperty("java.specification.version");
        if (javaSpecVersion.equals("1.8") || javaSpecVersion.equals("1.9")) {
            if (USE_COMPRESSED_OOP) {
                if (COMPRESSED_OOP_BASE != 0L) {
                    out.println("Using compressed oop with " + VMSupport.formatAddressAsHexByAddressSize(COMPRESSED_OOP_BASE) + " base address and " + COMPRESSED_OOP_SHIFT + "-bit shift.");
                } else {
                    out.println("Using compressed oop with " + COMPRESSED_OOP_SHIFT + "-bit shift.");
                }
            }
            if (USE_COMPRESSED_KLASS) {
                if (COMPRESSED_KLASS_BASE != 0L) {
                    out.println("Using compressed klass with " + VMSupport.formatAddressAsHexByAddressSize(COMPRESSED_KLASS_BASE) + " base address and " + COMPRESSED_KLASS_SHIFT + "-bit shift.");
                } else {
                    out.println("Using compressed klass with " + COMPRESSED_KLASS_SHIFT + "-bit shift.");
                }
            }
        } else if (USE_COMPRESSED_REFS) {
            if (COMPRESSED_REF_BASE != 0L) {
                out.println("Using compressed references with " + VMSupport.formatAddressAsHexByAddressSize(COMPRESSED_REF_BASE) + " base address and " + COMPRESSED_REF_SHIFT + "-bit shift.");
            } else {
                out.println("Using compressed references with " + COMPRESSED_REF_SHIFT + "-bit shift.");
            }
        }
        out.println("Objects are " + OBJ_ALIGNMENT + " bytes aligned.");
        out.printf("%-19s: %d, %d, %d, %d, %d, %d, %d, %d, %d [bytes]%n", "Field sizes by type", REF_SIZE, BOOLEAN_SIZE, BYTE_SIZE, CHAR_SIZE, SHORT_SIZE, INT_SIZE, FLOAT_SIZE, LONG_SIZE, DOUBLE_SIZE);
        out.printf("%-19s: %d, %d, %d, %d, %d, %d, %d, %d, %d [bytes]%n", "Array element sizes", U.arrayIndexScale(Object[].class), U.arrayIndexScale(boolean[].class), U.arrayIndexScale(byte[].class), U.arrayIndexScale(char[].class), U.arrayIndexScale(short[].class), U.arrayIndexScale(int[].class), U.arrayIndexScale(float[].class), U.arrayIndexScale(long[].class), U.arrayIndexScale(double[].class));
        out.close();
        return sw.toString();
    }

    private static String formatAddressAsHexByAddressSize(long address) {
        return "0x" + String.format("%" + ADDRESS_SIZE * 2 + "s", Long.toHexString(address).toUpperCase()).replace(' ', '0');
    }

    private static Object instantiateType(int type) {
        switch (type) {
            case 0: {
                return new MyObject1();
            }
            case 1: {
                return new MyObject2();
            }
            case 2: {
                return new MyObject3();
            }
            case 3: {
                return new MyObject4();
            }
            case 4: {
                return new MyObject5();
            }
        }
        throw new IllegalStateException();
    }

    private static int guessAlignment(int oopSize) {
        int COUNT = 100000;
        Random r = new Random();
        long min = -1L;
        for (int c = 0; c < 100000; ++c) {
            Object o1 = VMSupport.instantiateType(r.nextInt(5));
            Object o2 = VMSupport.instantiateType(r.nextInt(5));
            long diff = Math.abs(VMSupport.addressOf(o2, oopSize) - VMSupport.addressOf(o1, oopSize));
            min = min == -1L ? diff : MathUtil.gcd(min, diff);
        }
        return (int)min;
    }

    public static long addressOf(Object o) {
        return VMSupport.addressOf(o, REF_SIZE);
    }

    public static long addressOf(Object o, int oopSize) {
        long objectAddress;
        Object[] array = BUFFERS.get();
        array[0] = o;
        switch (oopSize) {
            case 4: {
                objectAddress = (long)U.getInt(array, OBJECT_ARRAY_BASE) & 0xFFFFFFFFL;
                break;
            }
            case 8: {
                objectAddress = U.getLong(array, OBJECT_ARRAY_BASE);
                break;
            }
            default: {
                throw new Error("unsupported address size: " + oopSize);
            }
        }
        array[0] = null;
        return VMSupport.toNativeAddress(objectAddress);
    }

    public static SizeInfo tryExactObjectSize(Object o, ClassLayout layout) {
        return new SizeInfo(o, layout);
    }

    public static int sizeOf(Object o) {
        if (InstrumentationSupport.instance() != null) {
            return VMSupport.align((int)InstrumentationSupport.instance().getObjectSize(o));
        }
        return new CurrentLayouter().layout(ClassData.parseInstance(o)).instanceSize();
    }

    public static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            Class<?> type = o.getClass().getComponentType();
            if (type == Boolean.TYPE) {
                return Arrays.toString((boolean[])o);
            }
            if (type == Byte.TYPE) {
                return Arrays.toString((byte[])o);
            }
            if (type == Short.TYPE) {
                return Arrays.toString((short[])o);
            }
            if (type == Character.TYPE) {
                return Arrays.toString((char[])o);
            }
            if (type == Integer.TYPE) {
                return Arrays.toString((int[])o);
            }
            if (type == Float.TYPE) {
                return Arrays.toString((float[])o);
            }
            if (type == Long.TYPE) {
                return Arrays.toString((long[])o);
            }
            if (type == Double.TYPE) {
                return Arrays.toString((double[])o);
            }
            Object[] oos = (Object[])o;
            Object[] strs = new String[oos.length];
            for (int i = 0; i < oos.length; ++i) {
                strs[i] = oos[i] == null ? "null" : VMSupport.safeToString(oos[i]);
            }
            return Arrays.toString(strs);
        }
        if (o.getClass().isPrimitive()) {
            return o.toString();
        }
        if (o.getClass() == Boolean.class) {
            return o.toString();
        }
        if (o.getClass() == Byte.class) {
            return o.toString();
        }
        if (o.getClass() == Short.class) {
            return o.toString();
        }
        if (o.getClass() == Character.class) {
            return o.toString();
        }
        if (o.getClass() == Integer.class) {
            return o.toString();
        }
        if (o.getClass() == Float.class) {
            return o.toString();
        }
        if (o.getClass() == Long.class) {
            return o.toString();
        }
        if (o.getClass() == Double.class) {
            return o.toString();
        }
        return "(object)";
    }

    static {
        int headerSize;
        U = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

            @Override
            public Unsafe run() {
                try {
                    Field unsafe = Unsafe.class.getDeclaredField("theUnsafe");
                    unsafe.setAccessible(true);
                    return (Unsafe)unsafe.get(null);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        OBJECT_ARRAY_BASE = U.arrayBaseOffset(Object[].class);
        BUFFERS = new ThreadLocal<Object[]>(){

            @Override
            protected Object[] initialValue() {
                return new Object[1];
            }
        };
        try {
            long off1 = U.objectFieldOffset(HeaderClass.class.getField("b1"));
            headerSize = (int)off1;
        }
        catch (NoSuchFieldException e) {
            headerSize = -1;
        }
        ADDRESS_SIZE = U.addressSize();
        VMOptions opts = VMOptions.getOptions();
        VM_NAME = opts.name;
        REF_SIZE = opts.sizeReference;
        OBJ_ALIGNMENT = opts.objectAlignment;
        OBJ_HEADER_SIZE = headerSize;
        ARRAY_HEADER_SIZE = OBJ_HEADER_SIZE + 4;
        USE_COMPRESSED_REFS = opts.compressedOopRef;
        COMPRESSED_REF_BASE = opts.compressedOopBase;
        COMPRESSED_REF_SHIFT = opts.compressedOopShift;
        OOP_SIZE = opts.oopSize;
        USE_COMPRESSED_OOP = opts.compressedOopRef;
        COMPRESSED_OOP_BASE = opts.compressedOopBase;
        COMPRESSED_OOP_SHIFT = opts.compressedOopShift;
        KLASS_OOP_SIZE = opts.klassOopSize;
        USE_COMPRESSED_KLASS = opts.compressedKlassRef;
        COMPRESSED_KLASS_BASE = opts.compressedKlassBase;
        COMPRESSED_KLASS_SHIFT = opts.compressedKlassShift;
        BOOLEAN_SIZE = opts.sizeBoolean;
        BYTE_SIZE = opts.sizeByte;
        CHAR_SIZE = opts.sizeChar;
        DOUBLE_SIZE = opts.sizeDouble;
        FLOAT_SIZE = opts.sizeFloat;
        INT_SIZE = opts.sizeInt;
        LONG_SIZE = opts.sizeLong;
        SHORT_SIZE = opts.sizeShort;
    }

    static class MyDoubles4 {
        private double f1;
        private double f2;
        private double f3;
        private double f4;

        MyDoubles4() {
        }
    }

    static class MyLongs4 {
        private long f1;
        private long f2;
        private long f3;
        private long f4;

        MyLongs4() {
        }
    }

    static class MyFloats4 {
        private float f1;
        private float f2;
        private float f3;
        private float f4;

        MyFloats4() {
        }
    }

    static class MyInts4 {
        private int f1;
        private int f2;
        private int f3;
        private int f4;

        MyInts4() {
        }
    }

    static class MyChars4 {
        private char f1;
        private char f2;
        private char f3;
        private char f4;

        MyChars4() {
        }
    }

    static class MyShorts4 {
        private short f1;
        private short f2;
        private short f3;
        private short f4;

        MyShorts4() {
        }
    }

    static class MyBytes4 {
        private byte f1;
        private byte f2;
        private byte f3;
        private byte f4;

        MyBytes4() {
        }
    }

    static class MyBooleans4 {
        private boolean f1;
        private boolean f2;
        private boolean f3;
        private boolean f4;

        MyBooleans4() {
        }
    }

    static class MyObject5 {
        private Object o;

        MyObject5() {
        }
    }

    static class MyObject4 {
        private long l;

        MyObject4() {
        }
    }

    static class MyObject3 {
        private int i;

        MyObject3() {
        }
    }

    static class MyObject2 {
        private boolean b;

        MyObject2() {
        }
    }

    static class MyObject1 {
        MyObject1() {
        }
    }

    static class HeaderClass {
        public boolean b1;

        HeaderClass() {
        }
    }

    static class CompressedOopsClass {
        public Object obj1;
        public Object obj2;

        CompressedOopsClass() {
        }
    }

    private static class VMOptions {
        private final String name;
        private final int objectAlignment;
        private final int oopSize;
        private final boolean compressedOopRef;
        private final long compressedOopBase;
        private final int compressedOopShift;
        private final int klassOopSize;
        private final boolean compressedKlassRef;
        private final long compressedKlassBase;
        private final int compressedKlassShift;
        private final int sizeReference;
        private final int sizeBoolean = VMOptions.getMinDiff(MyBooleans4.class);
        private final int sizeByte = VMOptions.getMinDiff(MyBytes4.class);
        private final int sizeShort = VMOptions.getMinDiff(MyShorts4.class);
        private final int sizeChar = VMOptions.getMinDiff(MyChars4.class);
        private final int sizeFloat = VMOptions.getMinDiff(MyFloats4.class);
        private final int sizeInt = VMOptions.getMinDiff(MyInts4.class);
        private final int sizeLong = VMOptions.getMinDiff(MyLongs4.class);
        private final int sizeDouble = VMOptions.getMinDiff(MyDoubles4.class);

        public static int getMinDiff(Class<?> klass) {
            try {
                int off1 = (int)U.objectFieldOffset(klass.getDeclaredField("f1"));
                int off2 = (int)U.objectFieldOffset(klass.getDeclaredField("f2"));
                int off3 = (int)U.objectFieldOffset(klass.getDeclaredField("f3"));
                int off4 = (int)U.objectFieldOffset(klass.getDeclaredField("f4"));
                return MathUtil.minDiff(off1, off2, off3, off4);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Infrastructure failure, klass = " + klass, e);
            }
        }

        public VMOptions(String name) {
            this.name = name;
            this.sizeReference = U.addressSize();
            this.objectAlignment = VMSupport.guessAlignment(this.sizeReference);
            this.oopSize = this.sizeReference;
            this.compressedOopRef = false;
            this.compressedOopBase = 0L;
            this.compressedOopShift = 0;
            this.klassOopSize = this.sizeReference;
            this.compressedKlassRef = false;
            this.compressedKlassBase = 0L;
            this.compressedKlassShift = 0;
        }

        public VMOptions(String name, int align) {
            this.name = name;
            this.sizeReference = 4;
            this.objectAlignment = align;
            this.oopSize = this.sizeReference;
            this.compressedOopRef = true;
            this.compressedOopBase = 0L;
            this.compressedOopShift = MathUtil.log2p(align);
            this.klassOopSize = this.sizeReference;
            this.compressedKlassRef = true;
            this.compressedKlassBase = 0L;
            this.compressedKlassShift = MathUtil.log2p(align);
        }

        public VMOptions(String name, int align, int compRefShift) {
            this.name = name;
            this.sizeReference = 4;
            this.objectAlignment = align;
            this.oopSize = this.sizeReference;
            this.compressedOopRef = true;
            this.compressedOopBase = 0L;
            this.compressedOopShift = compRefShift;
            this.klassOopSize = this.sizeReference;
            this.compressedKlassRef = true;
            this.compressedKlassBase = 0L;
            this.compressedKlassShift = compRefShift;
        }

        public VMOptions(String name, int align, int oopSize, boolean compOopRef, long compOopBase, int compOopShift, int klassOopSize, boolean compKlassRef, long compKlassBase, int compKlassShift) {
            this.name = name;
            this.sizeReference = oopSize;
            this.objectAlignment = align;
            this.oopSize = oopSize;
            this.compressedOopRef = compOopRef;
            this.compressedOopBase = compOopBase;
            this.compressedOopShift = compOopShift;
            this.klassOopSize = klassOopSize;
            this.compressedKlassRef = compKlassRef;
            this.compressedKlassBase = compKlassBase;
            this.compressedKlassShift = compKlassShift;
        }

        private static VMOptions getOptions() {
            int oopSize;
            VMOptions hsOpts = VMOptions.getHotspotSpecifics();
            if (hsOpts != null) {
                return hsOpts;
            }
            VMOptions jrOpts = VMOptions.getJRockitSpecifics();
            if (jrOpts != null) {
                return jrOpts;
            }
            try {
                long off1 = U.objectFieldOffset(CompressedOopsClass.class.getField("obj1"));
                long off2 = U.objectFieldOffset(CompressedOopsClass.class.getField("obj2"));
                oopSize = (int)Math.abs(off2 - off1);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Infrastructure failure", e);
            }
            if (oopSize != U.addressSize()) {
                return new VMOptions("Auto-detected", 3);
            }
            return new VMOptions("Auto-detected");
        }

        private static VMOptions getHotspotSpecifics() {
            String name = System.getProperty("java.vm.name");
            if (!name.contains("HotSpot") && !name.contains("OpenJDK")) {
                return null;
            }
            try {
                try {
                    HS_SA_CompressedReferencesResult compressedReferencesInfo = HS_SA_Support.getCompressedReferences();
                    if (compressedReferencesInfo != null) {
                        return new VMOptions("HotSpot", compressedReferencesInfo.getObjectAlignment(), compressedReferencesInfo.getOopSize(), compressedReferencesInfo.isCompressedOopsEnabled(), compressedReferencesInfo.getNarrowOopBase(), compressedReferencesInfo.getNarrowOopShift(), compressedReferencesInfo.getKlassOopSize(), compressedReferencesInfo.isCompressedKlassOopsEnabled(), compressedReferencesInfo.getNarrowKlassBase(), compressedReferencesInfo.getNarrowKlassShift());
                    }
                    System.out.println("Compressed references information couldn't be found via Hotspot SA.");
                }
                catch (Throwable t) {
                    System.err.println(t.getMessage());
                    System.err.println("WARNING: VM details, e.g. object alignment, reference size, compressed references info will be guessed.");
                    System.err.println();
                }
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectName mbean = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
                    CompositeDataSupport compressedOopsValue = (CompositeDataSupport)server.invoke(mbean, "getVMOption", new Object[]{"UseCompressedOops"}, new String[]{"java.lang.String"});
                    boolean compressedOops = Boolean.valueOf(compressedOopsValue.get("value").toString());
                    if (compressedOops) {
                        CompositeDataSupport alignmentValue = (CompositeDataSupport)server.invoke(mbean, "getVMOption", new Object[]{"ObjectAlignmentInBytes"}, new String[]{"java.lang.String"});
                        int align = Integer.valueOf(alignmentValue.get("value").toString());
                        return new VMOptions("HotSpot", align);
                    }
                    return new VMOptions("HotSpot");
                }
                catch (RuntimeMBeanException iae) {
                    return new VMOptions("HotSpot");
                }
            }
            catch (RuntimeException re) {
                System.err.println("Failed to read HotSpot-specific configuration properly, please report this as the bug");
                re.printStackTrace();
                return null;
            }
            catch (Exception exp) {
                System.err.println("Failed to read HotSpot-specific configuration properly, please report this as the bug");
                exp.printStackTrace();
                return null;
            }
        }

        private static VMOptions getJRockitSpecifics() {
            String name = System.getProperty("java.vm.name");
            if (!name.contains("JRockit")) {
                return null;
            }
            try {
                String[] split;
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                String str = (String)server.invoke(new ObjectName("oracle.jrockit.management:type=DiagnosticCommand"), "execute", new Object[]{"print_vm_state"}, new String[]{"java.lang.String"});
                for (String s : split = str.split("\n")) {
                    if (!s.contains("CompRefs")) continue;
                    Pattern pattern = Pattern.compile("(.*?)References are compressed, with heap base (.*?) and shift (.*?)\\.");
                    Matcher matcher = pattern.matcher(s);
                    if (matcher.matches()) {
                        return new VMOptions("JRockit (experimental)", 8, Integer.valueOf(matcher.group(3)));
                    }
                    return new VMOptions("JRockit (experimental)");
                }
                return null;
            }
            catch (RuntimeException re) {
                System.err.println("Failed to read JRockit-specific configuration properly, please report this as the bug");
                re.printStackTrace();
                return null;
            }
            catch (Exception exp) {
                System.err.println("Failed to read JRockit-specific configuration properly, please report this as the bug");
                exp.printStackTrace();
                return null;
            }
        }
    }

    public static class SizeInfo {
        private final int size;
        private final boolean exactSizeAvail;

        public SizeInfo(Object o, ClassLayout layout) {
            this.exactSizeAvail = InstrumentationSupport.instance() != null && o != null;
            this.size = this.exactSizeAvail ? (int)InstrumentationSupport.instance().getObjectSize(o) : layout.instanceSize();
        }

        public int instanceSize() {
            return this.size;
        }

        public boolean exactSize() {
            return this.exactSizeAvail;
        }
    }
}

