/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import net.sourceforge.pmd.cpd.renderer.CPDReportRenderer;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLRenderer
implements Renderer,
CPDRenderer,
CPDReportRenderer {
    private String encoding;

    public XMLRenderer() {
        this(null);
    }

    public XMLRenderer(String encoding) {
        this.setEncoding(encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding != null ? encoding : System.getProperty("file.encoding");
    }

    public String getEncoding() {
        return this.encoding;
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            return parser.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private void dumpDocToWriter(Document doc, Writer writer) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("version", "1.0");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.encoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("cdata-section-elements", "codefragment");
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String render(Iterator<Match> matches) {
        StringWriter writer = new StringWriter();
        try {
            this.render(matches, (Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public void render(Iterator<Match> matches, Writer writer) throws IOException {
        this.render(new CPDReport(CollectionUtil.toList(matches), Collections.emptyMap()), writer);
    }

    @Override
    public void render(CPDReport report, Writer writer) throws IOException {
        Document doc = this.createDocument();
        Element root = doc.createElement("pmd-cpd");
        Map<String, Integer> numberOfTokensPerFile = report.getNumberOfTokensPerFile();
        List<Match> matches = report.getMatches();
        doc.appendChild(root);
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(numberOfTokensPerFile.entrySet());
        for (Map.Entry entry : entries) {
            Element fileElement = doc.createElement("file");
            fileElement.setAttribute("path", (String)entry.getKey());
            fileElement.setAttribute("totalNumberOfTokens", String.valueOf(entry.getValue()));
            root.appendChild(fileElement);
        }
        for (Match match : matches) {
            root.appendChild(this.addCodeSnippet(doc, this.addFilesToDuplicationElement(doc, this.createDuplicationElement(doc, match), match), match));
        }
        this.dumpDocToWriter(doc, writer);
        writer.flush();
    }

    private Element addFilesToDuplicationElement(Document doc, Element duplication, Match match) {
        for (Mark mark : match) {
            Element file = doc.createElement("file");
            file.setAttribute("line", String.valueOf(mark.getBeginLine()));
            String filenameXml10 = StringUtil.removedInvalidXml10Characters(mark.getFilename());
            file.setAttribute("path", filenameXml10);
            file.setAttribute("endline", String.valueOf(mark.getEndLine()));
            int beginCol = mark.getBeginColumn();
            int endCol = mark.getEndColumn();
            if (beginCol != -1) {
                file.setAttribute("column", String.valueOf(beginCol));
            }
            if (endCol != -1) {
                file.setAttribute("endcolumn", String.valueOf(endCol));
            }
            int beginIndex = mark.getBeginTokenIndex();
            int endIndex = mark.getEndTokenIndex();
            file.setAttribute("begintoken", String.valueOf(beginIndex));
            if (endIndex != -1) {
                file.setAttribute("endtoken", String.valueOf(endIndex));
            }
            duplication.appendChild(file);
        }
        return duplication;
    }

    private Element addCodeSnippet(Document doc, Element duplication, Match match) {
        String codeSnippet = match.getSourceCodeSlice();
        if (codeSnippet != null) {
            String platformSpecific = codeSnippet.replace("\n", System.lineSeparator());
            Element codefragment = doc.createElement("codefragment");
            codefragment.appendChild(doc.createCDATASection(StringUtil.removedInvalidXml10Characters(platformSpecific)));
            duplication.appendChild(codefragment);
        }
        return duplication;
    }

    private Element createDuplicationElement(Document doc, Match match) {
        Element duplication = doc.createElement("duplication");
        duplication.setAttribute("lines", String.valueOf(match.getLineCount()));
        duplication.setAttribute("tokens", String.valueOf(match.getTokenCount()));
        return duplication;
    }
}

