/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.SaxonXPathRuleQuery;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.lang.xml.ast.XmlParser;
import net.sourceforge.pmd.lang.xpath.Initializer;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.DataMap;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.w3c.dom.Document;

final class SaxonDomXPathQuery {
    private static final NamePool NAME_POOL = new NamePool();
    private static final DataMap.SimpleDataKey<DocumentWrapper> SAXON_DOM_WRAPPER = DataMap.simpleDataKey((String)"pmd.saxon.dom.wrapper");
    private final String xpath;
    private final XPathExpressionWithProperties xpathExpression;
    private final Configuration configuration;

    SaxonDomXPathQuery(String xpath, String defaultNsUri, List<PropertyDescriptor<?>> properties) {
        this.xpath = xpath;
        this.configuration = new Configuration();
        this.configuration.setNamePool(NAME_POOL);
        this.xpathExpression = this.makeXPathExpression(this.xpath, defaultNsUri, properties);
    }

    private XPathExpressionWithProperties makeXPathExpression(String xpath, String defaultUri, List<PropertyDescriptor<?>> properties) {
        IndependentContext xpathStaticContext = new IndependentContext(this.configuration);
        xpathStaticContext.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
        xpathStaticContext.setDefaultElementNamespace(defaultUri);
        Initializer.initialize((IndependentContext)xpathStaticContext);
        Map<PropertyDescriptor<?>, XPathVariable> xpathVariables = this.declareXPathVariables(properties, (XPathStaticContext)xpathStaticContext);
        try {
            XPathEvaluator xpathEvaluator = new XPathEvaluator(this.configuration);
            xpathEvaluator.setStaticContext((XPathStaticContext)xpathStaticContext);
            XPathExpression expression = xpathEvaluator.createExpression(xpath);
            return new XPathExpressionWithProperties(expression, xpathVariables);
        }
        catch (XPathException e) {
            throw new ContextedRuntimeException((Throwable)e).addContextValue("XPath", (Object)xpath);
        }
    }

    private Map<PropertyDescriptor<?>, XPathVariable> declareXPathVariables(List<PropertyDescriptor<?>> accessibleProperties, XPathStaticContext xpathStaticContext) {
        HashMap xpathVariables = new HashMap();
        for (PropertyDescriptor<?> propertyDescriptor : accessibleProperties) {
            String name = propertyDescriptor.name();
            if (this.isExcludedProperty(name)) continue;
            XPathVariable xpathVariable = xpathStaticContext.declareVariable(null, name);
            xpathVariables.put(propertyDescriptor, xpathVariable);
        }
        return Collections.unmodifiableMap(xpathVariables);
    }

    private boolean isExcludedProperty(String name) {
        return "xpath".equals(name) || "defaultNsUri".equals(name) || "violationSuppressRegex".equals(name) || "violationSuppressXPath".equals(name);
    }

    public String toString() {
        return this.xpath;
    }

    public List<Node> evaluate(XmlParser.RootXmlNode root, PropertySource propertyValues) {
        DocumentWrapper wrapper = this.getSaxonDomWrapper(root);
        try {
            ArrayList<Node> result = new ArrayList<Node>();
            for (Item item : this.xpathExpression.evaluate(wrapper, propertyValues)) {
                NodeWrapper nodeInfo;
                Object domNode;
                if (!(item instanceof NodeWrapper) || !((domNode = (nodeInfo = (NodeWrapper)item).getUnderlyingNode()) instanceof org.w3c.dom.Node)) continue;
                XmlNode wrapped = root.wrap((org.w3c.dom.Node)domNode);
                result.add(wrapped);
            }
            return result;
        }
        catch (XPathException e) {
            throw new ContextedRuntimeException((Throwable)e).addContextValue("XPath", (Object)this.xpath);
        }
    }

    private DocumentWrapper getSaxonDomWrapper(XmlParser.RootXmlNode node) {
        DataMap userMap = node.getUserMap();
        if (userMap.isSet(SAXON_DOM_WRAPPER)) {
            return (DocumentWrapper)userMap.get(SAXON_DOM_WRAPPER);
        }
        Document domRoot = node.getNode();
        DocumentWrapper wrapper = new DocumentWrapper((org.w3c.dom.Node)domRoot, domRoot.getBaseURI(), this.configuration);
        userMap.set(SAXON_DOM_WRAPPER, (Object)wrapper);
        return wrapper;
    }

    static final class XPathExpressionWithProperties {
        final XPathExpression expr;
        final Map<PropertyDescriptor<?>, XPathVariable> xpathVariables;

        XPathExpressionWithProperties(XPathExpression expr, Map<PropertyDescriptor<?>, XPathVariable> xpathVariables) {
            this.expr = expr;
            this.xpathVariables = xpathVariables;
        }

        private List<Item> evaluate(DocumentWrapper elementNode, PropertySource properties) throws XPathException {
            XPathDynamicContext dynamicContext = this.createDynamicContext(elementNode, properties);
            return this.expr.evaluate(dynamicContext);
        }

        private XPathDynamicContext createDynamicContext(DocumentWrapper elementNode, PropertySource properties) {
            XPathDynamicContext dynamicContext = this.expr.createDynamicContext((Item)elementNode);
            for (Map.Entry<PropertyDescriptor<?>, XPathVariable> entry : this.xpathVariables.entrySet()) {
                ValueRepresentation saxonValue = XPathExpressionWithProperties.getSaxonValue(properties, entry);
                XPathVariable variable = entry.getValue();
                try {
                    dynamicContext.setVariable(variable, saxonValue);
                }
                catch (XPathException e) {
                    throw new ContextedRuntimeException((Throwable)e).addContextValue("Variable", (Object)variable);
                }
            }
            return dynamicContext;
        }

        private static ValueRepresentation getSaxonValue(PropertySource properties, Map.Entry<PropertyDescriptor<?>, XPathVariable> entry) {
            Object value = properties.getProperty(entry.getKey());
            Objects.requireNonNull(value, "null property value for " + entry.getKey());
            return SaxonXPathRuleQuery.getRepresentation(entry.getKey(), (Object)value);
        }
    }
}

