/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.api.JavaOperationMetricKey;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaMetricsRule;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class CognitiveComplexityRule
extends AbstractJavaMetricsRule {
    private static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("Cognitive Complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)15)).build();

    public CognitiveComplexityRule() {
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
    }

    private int getReportLevel() {
        return (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
    }

    @Override
    public final Object visit(ASTMethodOrConstructorDeclaration node, Object data) {
        int reportLevel;
        if (!JavaOperationMetricKey.COGNITIVE_COMPLEXITY.supports(node)) {
            return data;
        }
        int cognitive = (int)MetricsUtil.computeMetric((MetricKey)JavaOperationMetricKey.COGNITIVE_COMPLEXITY, (Node)node);
        if (cognitive >= (reportLevel = this.getReportLevel())) {
            this.addViolation(data, node, new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", PrettyPrintingUtil.displaySignature(node), String.valueOf(cognitive), String.valueOf(reportLevel)});
        }
        return data;
    }
}

