/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class ConfusingTernaryRule
extends AbstractJavaRule {
    private static PropertyDescriptor<Boolean> ignoreElseIfProperty = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreElseIf").desc("Ignore conditions with an else-if case")).defaultValue((Object)false)).build();

    public ConfusingTernaryRule() {
        this.definePropertyDescriptor(ignoreElseIfProperty);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        JavaNode jnode;
        JavaNode inode;
        if (node.getNumChildren() == 3 && (inode = (JavaNode)node.getChild(0)) instanceof ASTExpression && inode.getNumChildren() == 1 && ConfusingTernaryRule.isMatch(jnode = inode.getChild(0)) && (!((Boolean)this.getProperty(ignoreElseIfProperty)).booleanValue() || !(((JavaNode)node.getChild(2)).getChild(0) instanceof ASTIfStatement) && !(((JavaNode)node.getParent()).getParent() instanceof ASTIfStatement))) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        JavaNode inode;
        if (node.getNumChildren() > 0 && ConfusingTernaryRule.isMatch(inode = (JavaNode)node.getChild(0))) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }

    private static boolean isMatch(JavaNode node) {
        return ConfusingTernaryRule.isUnaryNot(node = ConfusingTernaryRule.unwrapParentheses(node)) || ConfusingTernaryRule.isNotEquals(node) || ConfusingTernaryRule.isConditionalWithAllMatches(node);
    }

    private static boolean isUnaryNot(JavaNode node) {
        return node instanceof ASTUnaryExpressionNotPlusMinus && "!".equals(node.getImage());
    }

    private static boolean isNotEquals(JavaNode node) {
        return node instanceof ASTEqualityExpression && "!=".equals(node.getImage()) && !ConfusingTernaryRule.isNullLiteral(node.getChild(0)) && !ConfusingTernaryRule.isNullLiteral(node.getChild(1));
    }

    private static boolean isNullLiteral(JavaNode node) {
        if ((node = ConfusingTernaryRule.unwrapParentheses(node)) instanceof ASTExpression && node.getNumChildren() == 1) {
            node = node.getChild(0);
        }
        if (node instanceof ASTPrimaryExpression && node.getNumChildren() == 1 && (node = node.getChild(0)) instanceof ASTPrimaryPrefix && node.getNumChildren() == 1 && (node = node.getChild(0)) instanceof ASTLiteral && node.getNumChildren() == 1) {
            return node.getChild(0) instanceof ASTNullLiteral;
        }
        return false;
    }

    private static boolean isConditionalWithAllMatches(JavaNode node) {
        if (!(node instanceof ASTConditionalAndExpression) && !(node instanceof ASTConditionalOrExpression)) {
            return false;
        }
        int n = node.getNumChildren();
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            JavaNode inode = node.getChild(i);
            if (ConfusingTernaryRule.isMatch(inode)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static JavaNode unwrapParentheses(JavaNode top) {
        JavaNode node = top;
        if (!(node instanceof ASTPrimaryExpression) || node.getNumChildren() != 1) {
            return top;
        }
        if (!((node = node.getChild(0)) instanceof ASTPrimaryPrefix) || node.getNumChildren() != 1) {
            return top;
        }
        if (!((node = node.getChild(0)) instanceof ASTExpression) || node.getNumChildren() != 1) {
            return top;
        }
        node = node.getChild(0);
        return ConfusingTernaryRule.unwrapParentheses(node);
    }
}

