/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl.visitors;

import java.util.List;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledBlock;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorReducedAdapter;
import net.sourceforge.pmd.lang.java.metrics.impl.CycloMetric;

@Deprecated
@InternalApi
public class NpathBaseVisitor
extends JavaParserVisitorReducedAdapter {
    public static final NpathBaseVisitor INSTANCE = new NpathBaseVisitor();

    private int multiplyChildrenComplexities(JavaNode node, Object data) {
        int product = 1;
        for (int i = 0; i < node.getNumChildren(); ++i) {
            JavaNode n = node.getChild(i);
            int childComplexity = (Integer)n.jjtAccept(this, data);
            int newProduct = product * childComplexity;
            if (newProduct < product) {
                product = Integer.MAX_VALUE;
                break;
            }
            product = newProduct;
        }
        return product;
    }

    private int sumChildrenComplexities(JavaNode node, Object data) {
        int sum = 0;
        for (int i = 0; i < node.getNumChildren(); ++i) {
            JavaNode n = node.getChild(i);
            int childComplexity = (Integer)n.jjtAccept(this, data);
            int newSum = sum + childComplexity;
            if (newSum < sum) {
                sum = Integer.MAX_VALUE;
                break;
            }
            sum = newSum;
        }
        return sum;
    }

    @Override
    public Object visit(ASTMethodOrConstructorDeclaration node, Object data) {
        return this.multiplyChildrenComplexities(node, data);
    }

    @Override
    public Object visit(JavaNode node, Object data) {
        return this.multiplyChildrenComplexities(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        List statementChildren = node.findChildrenOfType(ASTStatement.class);
        int complexity = node.hasElse() ? 0 : 1;
        for (ASTStatement element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        int boolCompIf = CycloMetric.booleanExpressionComplexity((Node)node.getFirstChildOfType(ASTExpression.class));
        return boolCompIf + complexity;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        int boolCompWhile = CycloMetric.booleanExpressionComplexity((Node)node.getFirstChildOfType(ASTExpression.class));
        int nPathWhile = (Integer)((ASTStatement)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompWhile + nPathWhile + 1;
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        int boolCompDo = CycloMetric.booleanExpressionComplexity((Node)node.getFirstChildOfType(ASTExpression.class));
        int nPathDo = (Integer)((ASTStatement)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompDo + nPathDo + 1;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        int boolCompFor = CycloMetric.booleanExpressionComplexity((Node)node.getFirstDescendantOfType(ASTExpression.class));
        int nPathFor = (Integer)((ASTStatement)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompFor + nPathFor + 1;
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        ASTExpression expr = (ASTExpression)node.getFirstChildOfType(ASTExpression.class);
        if (expr == null) {
            return 1;
        }
        int boolCompReturn = CycloMetric.booleanExpressionComplexity((Node)expr);
        int conditionalExpressionComplexity = this.multiplyChildrenComplexities(expr, data);
        if (conditionalExpressionComplexity > 1) {
            boolCompReturn += conditionalExpressionComplexity;
        }
        return boolCompReturn > 0 ? boolCompReturn : 1;
    }

    @Override
    public Object visit(ASTSwitchExpression node, Object data) {
        return this.handleSwitch(node, data);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        return this.handleSwitch(node, data);
    }

    public int handleSwitch(JavaNode node, Object data) {
        int boolCompSwitch = CycloMetric.booleanExpressionComplexity((Node)node.getFirstChildOfType(ASTExpression.class));
        int npath = 0;
        int caseRange = 0;
        for (JavaNode javaNode : node.children()) {
            int complexity;
            if (javaNode instanceof ASTSwitchLabel || javaNode instanceof ASTSwitchLabeledThrowStatement) {
                npath += caseRange;
                caseRange = 1;
                continue;
            }
            if (javaNode instanceof ASTSwitchLabeledExpression || javaNode instanceof ASTSwitchLabeledBlock) {
                npath += caseRange;
                caseRange = complexity = ((Integer)javaNode.jjtAccept(this, data)).intValue();
                continue;
            }
            complexity = (Integer)javaNode.jjtAccept(this, data);
            caseRange *= complexity;
        }
        return boolCompSwitch + (npath += caseRange);
    }

    @Override
    public Object visit(ASTSwitchLabel node, Object data) {
        if (node.isDefault()) {
            return 1;
        }
        return node.findChildrenOfType(ASTExpression.class).size();
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        ASTExpression wrapper = new ASTExpression(Integer.MAX_VALUE);
        wrapper.jjtAddChild(node.getChild(0), 0);
        int boolCompTernary = CycloMetric.booleanExpressionComplexity((Node)wrapper);
        return boolCompTernary + this.sumChildrenComplexities(node, data) - 1;
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        return this.sumChildrenComplexities(node, data);
    }
}

