/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.internal.JavaCCTokenizer;
import net.sourceforge.pmd.cpd.token.JavaCCTokenFilter;
import net.sourceforge.pmd.cpd.token.TokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.cpp.CppTokenManager;
import net.sourceforge.pmd.util.IOUtil;

public class CPPTokenizer
extends JavaCCTokenizer {
    private boolean skipBlocks = true;
    private String skipBlocksStart;
    private String skipBlocksEnd;
    private boolean ignoreLiteralSequences = false;

    public void setProperties(Properties properties) {
        this.skipBlocks = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocks", Boolean.TRUE.toString()));
        if (this.skipBlocks) {
            String skipBlocksPattern = properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocksPattern", "#if 0|#endif");
            String[] split = skipBlocksPattern.split("\\|", 2);
            this.skipBlocksStart = split[0];
            this.skipBlocksEnd = split.length == 1 ? split[0] : split[1];
        }
        this.ignoreLiteralSequences = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipLiteralSequences", Boolean.FALSE.toString()));
    }

    private String maybeSkipBlocks(String test) throws IOException {
        if (!this.skipBlocks) {
            return test;
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(test));){
            String line;
            StringBuilder filtered = new StringBuilder(test.length());
            boolean skip = false;
            while ((line = reader.readLine()) != null) {
                if (this.skipBlocksStart.equalsIgnoreCase(line.trim())) {
                    skip = true;
                } else if (skip && this.skipBlocksEnd.equalsIgnoreCase(line.trim())) {
                    skip = false;
                }
                if (!skip) {
                    filtered.append(line);
                }
                filtered.append(PMD.EOL);
            }
            String string = filtered.toString();
            return string;
        }
    }

    protected TokenManager getLexerForSource(SourceCode sourceCode) {
        try {
            StringBuilder buffer = sourceCode.getCodeBuffer();
            return new CppTokenManager(IOUtil.skipBOM((Reader)new StringReader(this.maybeSkipBlocks(buffer.toString()))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected TokenFilter getTokenFilter(TokenManager tokenManager) {
        return new CppTokenFilter(tokenManager, this.ignoreLiteralSequences);
    }

    private static class CppTokenFilter
    extends JavaCCTokenFilter {
        private final boolean ignoreLiteralSequences;
        private GenericToken discardingLiteralsUntil = null;
        private boolean discardCurrent = false;

        CppTokenFilter(TokenManager tokenManager, boolean ignoreLiteralSequences) {
            super(tokenManager);
            this.ignoreLiteralSequences = ignoreLiteralSequences;
        }

        protected void analyzeTokens(GenericToken currentToken, Iterable<GenericToken> remainingTokens) {
            this.discardCurrent = false;
            this.skipLiteralSequences(currentToken, remainingTokens);
        }

        private void skipLiteralSequences(GenericToken currentToken, Iterable<GenericToken> remainingTokens) {
            if (this.ignoreLiteralSequences) {
                int kind = currentToken.getKind();
                if (this.isDiscardingLiterals()) {
                    if (currentToken == this.discardingLiteralsUntil) {
                        this.discardingLiteralsUntil = null;
                        this.discardCurrent = true;
                    }
                } else if (kind == 17) {
                    GenericToken finalToken;
                    this.discardingLiteralsUntil = finalToken = CppTokenFilter.findEndOfSequenceOfLiterals(remainingTokens);
                }
            }
        }

        private static GenericToken findEndOfSequenceOfLiterals(Iterable<GenericToken> remainingTokens) {
            boolean seenLiteral = false;
            int braceCount = 0;
            block6: for (GenericToken token : remainingTokens) {
                switch (token.getKind()) {
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 130: {
                        seenLiteral = true;
                        continue block6;
                    }
                    case 26: {
                        continue block6;
                    }
                    case 17: {
                        ++braceCount;
                        continue block6;
                    }
                    case 18: {
                        if (--braceCount >= 0) continue block6;
                        return seenLiteral ? token : null;
                    }
                }
                return null;
            }
            return null;
        }

        private boolean isDiscardingLiterals() {
            return this.discardingLiteralsUntil != null;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.isDiscardingLiterals() || this.discardCurrent;
        }
    }
}

