/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.WhenBlock;
import apex.jorje.data.ast.WhenCase;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import java.util.List;
import java.util.Optional;

public class WhenBlockPrinter
implements Printer<WhenBlock> {
    private static final String WHEN = "when ";
    private static final String WHEN_ELSE = "when else ";
    private final PrinterFactory factory;

    public WhenBlockPrinter(PrinterFactory factory) {
        this.factory = factory;
    }

    @Override
    public String print(WhenBlock x, final PrintContext ctx) {
        final PrinterFactory nestedFactory = this.factory.nestedPrinterFactory();
        final String indent = nestedFactory.indent();
        return x.match(new WhenBlock.MatchBlock<String>(){

            @Override
            public String _case(WhenBlock.ValueWhen x) {
                Printer<List<WhenCase>> whenPrinter = ListPrinter.create(nestedFactory.whenCasePrinter(), ", ", "", "");
                return indent + WhenBlockPrinter.WHEN + whenPrinter.print(x.whenCases, ctx) + " " + nestedFactory.optionalNestedStmntPrinter().print(Optional.of(x.stmnt), ctx);
            }

            @Override
            public String _case(WhenBlock.TypeWhen x) {
                return indent + WhenBlockPrinter.WHEN + nestedFactory.typeRefPrinter().print(x.typeRef, ctx) + " " + nestedFactory.identifierPrinter().print(x.name, ctx) + " " + nestedFactory.optionalNestedStmntPrinter().print(Optional.of(x.stmnt), ctx);
            }

            @Override
            public String _case(WhenBlock.ElseWhen x) {
                return indent + WhenBlockPrinter.WHEN_ELSE + nestedFactory.optionalNestedStmntPrinter().print(Optional.of(x.stmnt), ctx);
            }
        });
    }
}

