/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.lsp.impl.workspace.ServerSetup;
import apex.jorje.lsp.impl.workspace.WorkspaceChangeListenerDispatcher;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardWorkspaceService
implements WorkspaceService {
    private static final Logger logger = LoggerFactory.getLogger(StandardWorkspaceService.class);
    private final WorkspaceChangeListenerDispatcher dispatcher;

    @Inject
    public StandardWorkspaceService(WorkspaceChangeListenerDispatcher dispatcher, Provider<ServerSetup> serverSetupProvider) {
        this.dispatcher = dispatcher;
    }

    @Nullable
    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams workspaceSymbolParams) {
        return null;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        logger.info("Workspace configuration changed");
        this.dispatcher.didChangeConfiguration(params);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        logger.info("Workspace watched files changed");
        this.dispatcher.didChangeWatchedFiles(params);
    }
}

