/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Node node;
    private int namecode = -1;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;
    protected int span = 1;

    protected NodeWrapper(Node node, NodeWrapper parent, int index) {
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected NodeWrapper makeWrapper(Node node, DocumentWrapper docWrapper) {
        if (node == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: Node must not be null");
        }
        if (docWrapper == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: DocumentWrapper must not be null");
        }
        return this.makeWrapper(node, docWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Node node, DocumentWrapper docWrapper, NodeWrapper parent, int index) {
        NodeWrapper wrapper;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                return docWrapper;
            }
            case 1: {
                wrapper = new NodeWrapper(node, parent, index);
                wrapper.nodeKind = 1;
                break;
            }
            case 2: {
                wrapper = new NodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)2;
                break;
            }
            case 3: {
                wrapper = new NodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)3;
                break;
            }
            case 4: {
                wrapper = new NodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)3;
                break;
            }
            case 8: {
                wrapper = new NodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)8;
                break;
            }
            case 7: {
                wrapper = new NodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node.toString());
            }
        }
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 631;
        }
        return 630;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof NodeWrapper)) {
            return false;
        }
        if (this.docWrapper.domLevel3) {
            return this.node.isSameNode(((NodeWrapper)other).node);
        }
        NodeWrapper ow = (NodeWrapper)other;
        return this.getNodeKind() == ow.getNodeKind() && this.getNameCode() == ow.getNameCode() && this.getSiblingPosition() == ow.getSiblingPosition() && this.getParent().isSameNodeInfo(ow.getParent());
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        FastStringBuffer buffer = new FastStringBuffer(20);
        this.generateId(buffer);
        return buffer.toString().hashCode();
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String uri) {
        this.docWrapper.baseURI = uri;
    }

    public String getBaseURI() {
        NodeWrapper n = this;
        if (this.getNodeKind() != 1) {
            n = this.getParent();
        }
        while (n != null) {
            String xmlbase = n.getAttributeValue(385);
            if (xmlbase != null) {
                return xmlbase;
            }
            n = n.getParent();
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof NodeWrapper && this.docWrapper.domLevel3) {
            if (this.isSameNodeInfo(other)) {
                return 0;
            }
            try {
                short relationship = this.node.compareDocumentPosition(((NodeWrapper)other).node);
                if ((relationship & 0xA) != 0) {
                    return 1;
                }
                if ((relationship & 0x14) != 0) {
                    return -1;
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (other instanceof SiblingCountingNode) {
            return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)other));
        }
        return -other.compareOrder((NodeInfo)this);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        switch (this.nodeKind) {
            case 1: 
            case 9: {
                NodeList children1 = this.node.getChildNodes();
                StringBuffer sb1 = new StringBuffer(16);
                NodeWrapper.expandStringValue(children1, sb1);
                return sb1;
            }
            case 2: {
                return NodeWrapper.emptyIfNull(((Attr)this.node).getValue());
            }
            case 3: {
                if (this.span == 1) {
                    return NodeWrapper.emptyIfNull(this.node.getNodeValue());
                }
                FastStringBuffer fsb = new FastStringBuffer(100);
                Node textNode = this.node;
                for (int i = 0; i < this.span; ++i) {
                    fsb.append(NodeWrapper.emptyIfNull(textNode.getNodeValue()));
                    textNode = textNode.getNextSibling();
                }
                return fsb.condense();
            }
            case 7: 
            case 8: {
                return NodeWrapper.emptyIfNull(this.node.getNodeValue());
            }
        }
        return "";
    }

    private static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    private static void expandStringValue(NodeList list, StringBuffer sb) {
        int len = list.getLength();
        block4: for (int i = 0; i < len; ++i) {
            Node child = list.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    NodeWrapper.expandStringValue(child.getChildNodes(), sb);
                    continue block4;
                }
                case 7: 
                case 8: {
                    continue block4;
                }
                default: {
                    sb.append(child.getNodeValue());
                }
            }
        }
    }

    public int getNameCode() {
        if (this.namecode != -1) {
            return this.namecode;
        }
        int nodeKind = this.getNodeKind();
        if (nodeKind == 1 || nodeKind == 2) {
            String prefix = this.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            this.namecode = this.docWrapper.getNamePool().allocate(prefix, this.getURI(), this.getLocalPart());
            return this.namecode;
        }
        if (nodeKind == 7) {
            this.namecode = this.docWrapper.getNamePool().allocate("", "", this.getLocalPart());
            return this.namecode;
        }
        return -1;
    }

    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: {
                String s = this.node.getLocalName();
                if (s == null) {
                    String n = this.getDisplayName();
                    int colon = n.indexOf(58);
                    if (colon >= 0) {
                        return n.substring(colon + 1);
                    }
                    return n;
                }
                return s;
            }
            case 7: {
                return this.node.getNodeName();
            }
        }
        return null;
    }

    public String getURI() {
        String[] parts;
        NodeWrapper element;
        if (this.nodeKind == 1) {
            element = this;
        } else if (this.nodeKind == 2) {
            element = this.parent;
        } else {
            return "";
        }
        String uri = this.node.getNamespaceURI();
        if (uri != null) {
            return uri;
        }
        if (this.node.getNodeName().startsWith("xml:")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        try {
            parts = Name11Checker.getInstance().getQNameParts((CharSequence)this.node.getNodeName());
        }
        catch (QNameException e) {
            throw new IllegalStateException("Invalid QName in DOM node. " + (Object)((Object)e));
        }
        if (this.nodeKind == 2 && parts[0].length() == 0) {
            uri = "";
        } else {
            NodeInfo ns;
            AxisIterator nsiter = element.iterateAxis((byte)8);
            while ((ns = (NodeInfo)nsiter.next()) != null) {
                if (!ns.getLocalPart().equals(parts[0])) continue;
                uri = ns.getStringValue();
                break;
            }
            if (uri == null) {
                if (parts[0].length() == 0) {
                    uri = "";
                } else {
                    throw new IllegalStateException("Undeclared namespace prefix in DOM input: " + parts[0]);
                }
            }
        }
        return uri;
    }

    public String getPrefix() {
        int kind = this.getNodeKind();
        if (kind == 1 || kind == 2) {
            String name = this.node.getNodeName();
            int colon = name.indexOf(58);
            if (colon < 0) {
                return "";
            }
            return name.substring(0, colon);
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                return this.node.getNodeName();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            switch (this.getNodeKind()) {
                case 2: {
                    this.parent = this.makeWrapper(((Attr)this.node).getOwnerElement(), this.docWrapper);
                    break;
                }
                default: {
                    Node p = this.node.getParentNode();
                    if (p == null) {
                        return null;
                    }
                    this.parent = this.makeWrapper(p, this.docWrapper);
                }
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    int ix = 0;
                    Node start = this.node;
                    while (true) {
                        if ((start = start.getPreviousSibling()) == null) {
                            this.index = ix;
                            return ix;
                        }
                        ++ix;
                    }
                }
                case 2: {
                    int ix = 0;
                    int fp = this.getFingerprint();
                    AxisIterator iter = this.parent.iterateAxis((byte)2);
                    while (true) {
                        NodeInfo n;
                        if ((n = (NodeInfo)iter.next()) == null || n.getFingerprint() == fp) {
                            this.index = ix;
                            return ix;
                        }
                        ++ix;
                    }
                }
                case 13: {
                    int ix = 0;
                    int fp = this.getFingerprint();
                    AxisIterator iter = this.parent.iterateAxis((byte)8);
                    while (true) {
                        NodeInfo n;
                        if ((n = (NodeInfo)iter.next()) == null || n.getFingerprint() == fp) {
                            this.index = ix;
                            return ix;
                        }
                        ++ix;
                    }
                }
            }
            this.index = 0;
            return this.index;
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AncestorEnumeration((NodeInfo)this, false);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return SingleNodeIterator.makeIterator((NodeInfo)this);
                }
                return new Navigator.AncestorEnumeration((NodeInfo)this, true);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new ChildEnumeration(this, true, true, false);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
            }
            case 6: {
                return new Navigator.FollowingEnumeration((NodeInfo)this);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new ChildEnumeration(this, false, true, false);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return NamespaceIterator.makeIterator((NodeInfo)this, null);
            }
            case 9: {
                this.getParent();
                return SingleNodeIterator.makeIterator((NodeInfo)this.parent);
            }
            case 10: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, false);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new ChildEnumeration(this, false, false, false);
            }
            case 12: {
                return SingleNodeIterator.makeIterator((NodeInfo)this);
            }
            case 13: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        if (axisNumber == 3 && nodeTest.getPrimitiveType() == 1) {
            if (this.hasChildNodes()) {
                return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, true, true, true), nodeTest);
            }
            return EmptyIterator.getInstance();
        }
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    public String getAttributeValue(int fingerprint) {
        NameTest test = new NameTest(2, fingerprint, this.getNamePool());
        AxisIterator iterator = this.iterateAxis((byte)2, (NodeTest)test);
        NodeInfo attribute = (NodeInfo)iterator.next();
        if (attribute == null) {
            return null;
        }
        return attribute.getStringValue();
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        return this.node.getNodeType() != 2 && this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)buffer, (boolean)true);
    }

    public int getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)out, (NamePool)this.docWrapper.getNamePool(), (int)whichNamespaces, (boolean)copyAnnotations, (int)locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        if (this.node.getNodeType() == 1) {
            Element elem = (Element)this.node;
            NamedNodeMap atts = elem.getAttributes();
            if (atts == null) {
                return EMPTY_NAMESPACE_LIST;
            }
            int count = 0;
            int attsLen = atts.getLength();
            for (int i = 0; i < attsLen; ++i) {
                Attr att = (Attr)atts.item(i);
                String attName = att.getName();
                if (attName.equals("xmlns")) {
                    ++count;
                    continue;
                }
                if (!attName.startsWith("xmlns:")) continue;
                ++count;
            }
            if (count == 0) {
                return EMPTY_NAMESPACE_LIST;
            }
            int[] result = buffer == null || count > buffer.length ? new int[count] : buffer;
            NamePool pool = this.getNamePool();
            int n = 0;
            for (int i = 0; i < attsLen; ++i) {
                String uri;
                String prefix;
                Attr att = (Attr)atts.item(i);
                String attName = att.getName();
                if (attName.equals("xmlns")) {
                    prefix = "";
                    uri = att.getValue();
                    result[n++] = pool.allocateNamespaceCode(prefix, uri);
                    continue;
                }
                if (!attName.startsWith("xmlns:")) continue;
                prefix = attName.substring(6);
                uri = att.getValue();
                result[n++] = pool.allocateNamespaceCode(prefix, uri);
            }
            if (count < result.length) {
                result[count] = -1;
            }
            return result;
        }
        return null;
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    private final class ChildEnumeration
    extends AxisIteratorImpl
    implements LookaheadIterator {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private boolean downwards;
        private boolean forwards;
        private boolean elementsOnly;
        NodeList childNodes;
        private int childNodesLength;
        private int ix;
        private int currentSpan;

        public ChildEnumeration(NodeWrapper start, boolean downwards, boolean forwards, boolean elementsOnly) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            this.elementsOnly = elementsOnly;
            this.position = 0;
            this.currentSpan = 1;
            this.commonParent = downwards ? start : (NodeWrapper)start.getParent();
            this.childNodes = this.commonParent.node.getChildNodes();
            this.childNodesLength = this.childNodes.getLength();
            if (downwards) {
                this.currentSpan = 1;
                this.ix = forwards ? -1 : this.childNodesLength;
            } else {
                this.ix = start.getSiblingPosition();
                this.currentSpan = start.span;
            }
        }

        private int skipPrecedingTextNodes() {
            Node node;
            short kind;
            int count;
            for (count = 0; this.ix >= count && ((kind = (node = this.childNodes.item(this.ix - count)).getNodeType()) == 3 || kind == 4); ++count) {
            }
            return count == 0 ? 1 : count;
        }

        private int skipFollowingTextNodes() {
            Node node;
            short kind;
            int count = 0;
            int pos = this.ix;
            int len = this.childNodesLength;
            while (pos < len && ((kind = (node = this.childNodes.item(pos)).getNodeType()) == 3 || kind == 4)) {
                ++pos;
                ++count;
            }
            return count == 0 ? 1 : count;
        }

        public boolean hasNext() {
            if (this.forwards) {
                return this.ix + this.currentSpan < this.childNodesLength;
            }
            return this.ix > 0;
        }

        public Item next() {
            Node currentDomNode;
            block8: while (true) {
                if (this.forwards) {
                    this.ix += this.currentSpan;
                    if (this.ix >= this.childNodesLength) {
                        this.position = -1;
                        return null;
                    }
                    this.currentSpan = this.skipFollowingTextNodes();
                    currentDomNode = this.childNodes.item(this.ix);
                    switch (currentDomNode.getNodeType()) {
                        case 10: {
                            continue block8;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            if (this.elementsOnly) continue block8;
                        }
                    }
                    NodeWrapper wrapper = NodeWrapper.this.makeWrapper(currentDomNode, NodeWrapper.this.docWrapper, this.commonParent, this.ix);
                    wrapper.span = this.currentSpan;
                    ++this.position;
                    this.current = wrapper;
                    return this.current;
                }
                --this.ix;
                if (this.ix < 0) {
                    this.position = -1;
                    return null;
                }
                this.currentSpan = this.skipPrecedingTextNodes();
                this.ix -= this.currentSpan - 1;
                currentDomNode = this.childNodes.item(this.ix);
                switch (currentDomNode.getNodeType()) {
                    case 10: {
                        continue block8;
                    }
                    case 1: {
                        break block8;
                    }
                    default: {
                        if (!this.elementsOnly) break block8;
                        continue block8;
                    }
                }
                break;
            }
            NodeWrapper wrapper = NodeWrapper.this.makeWrapper(currentDomNode, NodeWrapper.this.docWrapper, this.commonParent, this.ix);
            wrapper.span = this.currentSpan;
            ++this.position;
            this.current = wrapper;
            return this.current;
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards, this.elementsOnly);
        }

        public int getProperties() {
            return 4;
        }
    }

    private final class AttributeEnumeration
    implements AxisIterator,
    LookaheadIterator {
        private ArrayList attList = new ArrayList(10);
        private int ix = 0;
        private NodeWrapper start;
        private NodeWrapper current;

        public AttributeEnumeration(NodeWrapper start) {
            this.start = start;
            NamedNodeMap atts = start.node.getAttributes();
            if (atts != null) {
                int attsLen = atts.getLength();
                for (int i = 0; i < attsLen; ++i) {
                    String name = atts.item(i).getNodeName();
                    if (name.startsWith("xmlns") && (name.length() == 5 || name.charAt(5) == ':')) continue;
                    this.attList.add(atts.item(i));
                }
            }
            this.ix = 0;
        }

        public boolean hasNext() {
            return this.ix < this.attList.size();
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            if (this.ix >= this.attList.size()) {
                return null;
            }
            this.current = this.start.makeWrapper((Attr)this.attList.get(this.ix), NodeWrapper.this.docWrapper, this.start, this.ix);
            ++this.ix;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.ix + 1;
        }

        public void close() {
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValueCS();
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }

        public int getProperties() {
            return 4;
        }
    }
}

