/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.benchmark;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;

public class TimingReport {
    private final long wallClockMillis;
    private final Map<TimeTracker.TimedOperationKey, TimeTracker.TimedResult> results;

    TimingReport(long wallClockMillis, Map<TimeTracker.TimedOperationKey, TimeTracker.TimedResult> accumulatedResults) {
        this.wallClockMillis = wallClockMillis;
        this.results = accumulatedResults;
    }

    public Map<String, TimeTracker.TimedResult> getLabeledMeasurements(TimedOperationCategory category) {
        HashMap<String, TimeTracker.TimedResult> ret = new HashMap<String, TimeTracker.TimedResult>();
        for (Map.Entry<TimeTracker.TimedOperationKey, TimeTracker.TimedResult> entry : this.results.entrySet()) {
            TimeTracker.TimedOperationKey timedOperation = entry.getKey();
            if (timedOperation.category != category || timedOperation.label == null) continue;
            ret.put(timedOperation.label, entry.getValue());
        }
        return ret;
    }

    public TimeTracker.TimedResult getUnlabeledMeasurements(TimedOperationCategory category) {
        for (Map.Entry<TimeTracker.TimedOperationKey, TimeTracker.TimedResult> entry : this.results.entrySet()) {
            TimeTracker.TimedOperationKey timedOperation = entry.getKey();
            if (timedOperation.category != category || timedOperation.label != null) continue;
            return entry.getValue();
        }
        return null;
    }

    public long getWallClockMillis() {
        return this.wallClockMillis;
    }
}

