/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf;

import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexParserVisitorAdapter;
import org.apache.commons.lang3.tuple.Pair;

final class ApexClassPropertyTypesVisitor
extends ApexParserVisitorAdapter {
    private static final String BEAN_GETTER_PREFIX = "get";
    private static final String PROPERTY_PREFIX_ACCESSOR = "__sfdc_";
    private static final String RETURN_TYPE_VOID = "void";
    private final List<Pair<String, BasicType>> variables = new ArrayList<Pair<String, BasicType>>();

    ApexClassPropertyTypesVisitor() {
    }

    public List<Pair<String, BasicType>> getVariables() {
        return this.variables;
    }

    public Object visit(ASTMethod node, Object data) {
        MethodInfo mi = ((Method)node.getNode()).getMethodInfo();
        if (mi.getParameterTypes().isEmpty() && this.isVisibleToVisualForce(node) && !RETURN_TYPE_VOID.equalsIgnoreCase(mi.getReturnType().getApexName()) && (mi.getGenerated().equals((Object)Generated.USER) || mi.isPropertyAccessor())) {
            StringBuilder sb = new StringBuilder();
            List parents = node.getParentsOfType(ASTUserClass.class);
            Collections.reverse(parents);
            for (ASTUserClass parent : parents) {
                sb.append(parent.getImage()).append(".");
            }
            String name = node.getImage();
            for (String prefix : new String[]{BEAN_GETTER_PREFIX, PROPERTY_PREFIX_ACCESSOR}) {
                if (!name.startsWith(prefix)) continue;
                name = name.substring(prefix.length());
            }
            sb.append(name);
            this.variables.add((Pair<String, BasicType>)Pair.of((Object)sb.toString(), (Object)mi.getReturnType().getBasicType()));
        }
        return super.visit((ApexNode)node, data);
    }

    private boolean isVisibleToVisualForce(ASTMethod node) {
        ASTModifierNode modifier = (ASTModifierNode)node.getFirstChildOfType(ASTModifierNode.class);
        return modifier.isGlobal() | modifier.isPublic();
    }
}

