/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.Result;
import apex.jorje.semantic.symbol.member.method.MemoizingMethodTable;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.MoreLists;
import java.util.Collection;
import java.util.List;

public class JavaMethodTable
extends MemoizingMethodTable {
    private final StandardMethodTable methods = new StandardMethodTable();

    @Override
    public Result<MethodInfo> getApproximate(TypeInfo referencingType, String methodName, List<TypeInfo> parameterTypes, MethodLookupMode mode) {
        return this.methods.getApproximate(referencingType, methodName, this.normalizeForJavaParameterTypes(parameterTypes), mode);
    }

    @Override
    public MethodInfo get(Signature signature) {
        return this.methods.get(this.normalizeForJavaParameterTypes(signature));
    }

    @Override
    public MethodInfo remove(Signature signature) {
        return this.methods.remove(signature);
    }

    @Override
    public Result<Void> addNoDuplicatesAllowed(MethodInfo method) {
        return this.methods.addNoDuplicatesAllowed(method);
    }

    @Override
    public Result<Void> addDuplicatesAllowed(MethodInfo method) {
        return this.methods.addDuplicatesAllowed(method);
    }

    @Override
    public MethodTable resolve() {
        this.methods.resolve();
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.methods.isResolved();
    }

    @Override
    public Collection<MethodInfo> all() {
        return this.methods.all();
    }

    private Signature normalizeForJavaParameterTypes(Signature signature) {
        return SignatureFactory.create(signature.getName(), signature.getReturnType(), this.normalizeForJavaParameterTypes(signature.getParameterTypes()));
    }

    private List<TypeInfo> normalizeForJavaParameterTypes(List<TypeInfo> parameterTypes) {
        return parameterTypes.stream().map(type -> {
            switch (type.getBasicType()) {
                case LIST: {
                    return ReifiedTypeInfos.OBJECT_LIST;
                }
                case SET: {
                    return ReifiedTypeInfos.OBJECT_SET;
                }
                case MAP: {
                    return ReifiedTypeInfos.STRING_TO_OBJECT_MAP;
                }
            }
            return type;
        }).collect(MoreLists.toImmutableList(parameterTypes.size()));
    }
}

