/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import apex.jorje.semantic.ast.member.Method;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class MethodNodeMatcher
extends TypeSafeDiagnosingMatcher<Method> {
    private final String expectedCanonicalName;

    private MethodNodeMatcher(String expectedCanonicalName) {
        this.expectedCanonicalName = expectedCanonicalName;
    }

    public static MethodNodeMatcher isMethodNodeWithCanonicalName(String expectedCanonicalName) {
        return new MethodNodeMatcher(expectedCanonicalName);
    }

    protected boolean matchesSafely(Method method, Description description) {
        if (method == null) {
            description.appendText("method is null");
            return false;
        }
        if (method.getMethodInfo() == null) {
            description.appendText("method is null");
            return false;
        }
        if (!Objects.equals(method.getMethodInfo().getCanonicalName(), this.expectedCanonicalName)) {
            description.appendText("Does not match canonical name ");
            description.appendValue((Object)method.getMethodInfo().getCanonicalName());
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("A Method node with the canonical name ").appendValue((Object)this.expectedCanonicalName);
    }
}

