/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import com.google.common.collect.MoreSets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum DateFormulaEnum {
    LAST_FISCAL_QUARTER,
    THIS_FISCAL_QUARTER,
    NEXT_FISCAL_QUARTER,
    LAST_FISCAL_YEAR,
    THIS_FISCAL_YEAR,
    NEXT_FISCAL_YEAR,
    LAST_QUARTER,
    THIS_QUARTER,
    NEXT_QUARTER,
    LAST_YEAR,
    THIS_YEAR,
    NEXT_YEAR,
    LAST_WEEK,
    THIS_WEEK,
    NEXT_WEEK,
    LAST_MONTH,
    THIS_MONTH,
    NEXT_MONTH,
    NEXT_N_WEEKS,
    LAST_N_WEEKS,
    LAST_N_MONTHS,
    NEXT_N_MONTHS,
    LAST_N_QUARTERS,
    NEXT_N_QUARTERS,
    LAST_N_YEARS,
    NEXT_N_YEARS,
    LAST_N_FISCAL_QUARTERS,
    NEXT_N_FISCAL_QUARTERS,
    LAST_N_FISCAL_YEARS,
    NEXT_N_FISCAL_YEARS,
    YESTERDAY,
    TODAY,
    TOMORROW,
    LAST_90_DAYS,
    NEXT_90_DAYS,
    LAST_N_DAYS,
    NEXT_N_DAYS,
    N_YEARS_AGO,
    N_FISCAL_YEARS_AGO,
    N_QUARTERS_AGO,
    N_FISCAL_QUARTERS_AGO,
    N_MONTHS_AGO,
    N_WEEKS_AGO,
    N_DAYS_AGO;

    private static final Set<String> ALL_DATE_FORMULAS;

    public static boolean isDateFormula(String s) {
        return ALL_DATE_FORMULAS.contains(s.toUpperCase());
    }

    static {
        ALL_DATE_FORMULAS = MoreSets.toImmutableSet(Arrays.stream(DateFormulaEnum.values()).map(Enum::name).collect(Collectors.toSet()));
    }
}

